package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CountDownViewStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaCountDownViewProperties extends AbstractMetaObject implements IPropertyMerger<MetaCountDownViewProperties>{

	public static final int DEFAULT_MAX_TIMER = 60;

	/** 显示样式：Rectangle-矩形样式，Circle-圆形样式 */
	private Integer style = CountDownViewStyle.RECTANGLE;
	/** 步进值，单位为秒 */
	private Integer stepper = 1;
	/** 计时结束事件 */
	private MetaBaseScript onFinish = null;
	/** 计时点击事件 */
	private MetaBaseScript onClick = null;
	/** 是否重复 */
	private Boolean repeat = false;
	/** 最大值 */
	private Integer maxTime = DEFAULT_MAX_TIMER;
	
	/** 结束时显示文本 */
	private String endCaption = "";

	/**
	 * 获取显示样式
	 * @return 显示样式：Rectangle-矩形样式，Circle-圆形样式 ，参考{@link CountDownViewStyle}
	 */
	public Integer getStyle() {
		return style;
	}

	/**
	 * 设置显示样式
	 * @param style 显示样式：Rectangle-矩形样式，Circle-圆形样式 ，参考{@link CountDownViewStyle}
	 */
	public void setStyle(Integer style) {
		this.style = style;
	}

	/**
	 * 获取步进值
	 * @return 步进值，单位为秒
	 */
	public Integer getStepper() {
		return stepper;
	}

	/**
	 * 设置步进值
	 * @param stepper 步进值，单位为秒
	 */
	public void setStepper(Integer stepper) {
		this.stepper = stepper;
	}

	/**
	 * 获取倒数计时结束后事件
	 * @return 倒数计时结束后事件
	 */
	public MetaBaseScript getOnFinish() {
		return onFinish;
	}

	/**
	 * 设置倒数计时结束后事件
	 * @param onFinish 倒数计时结束后事件
	 */
	public void setOnFinish(MetaBaseScript onFinish) {
		this.onFinish = onFinish;
	}

	/**
	 * 获取点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return onClick;
	}

	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 是否重复 
	 * @return 是否重复 
	 */
	public Boolean isRepeat() {
		return repeat;
	}

	/**
	 * 设置是否重复 
	 * @param repeat 是否重复 
	 */
	public void setRepeat(Boolean repeat) {
		this.repeat = repeat;
	}

	/**
	 * 获取倒数最大值
	 * @return 倒数最大值
	 */
	public Integer getMaxTime() {
		return maxTime;
	}

	/**
	 * 设置倒数最大值
	 * @param maxTime 倒数最大值
	 */
	public void setMaxTime(Integer maxTime) {
		this.maxTime = maxTime;
	}
	
	/**
	 * 获取结束时显示文本
	 * @return 结束时显示文本
	 */
	public String getEndCaption() {
		return endCaption;
	}
	
	/**
	 * 设置结束时显示文本
	 * @param endCaption 结束时显示文本
	 */
	public void setEndCaption(String endCaption) {
		this.endCaption = endCaption;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(onClick);
		list.add(onFinish);
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject resultMetaObj = null;
		if (MetaConstants.Event_OnClick.equalsIgnoreCase(tagName)) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObj = onClick;
		} else if (MetaConstants.Event_OnFinish.equalsIgnoreCase(tagName)) {
			onFinish = new MetaBaseScript(MetaConstants.Event_OnFinish);
			resultMetaObj = onFinish;
		}
		return resultMetaObj;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaCountDownViewProperties newObject = (MetaCountDownViewProperties) newInstance();
		newObject.setOnClick(onClick);
		newObject.setOnFinish(onFinish);
		newObject.setStepper(stepper);
		newObject.setStyle(style);
		newObject.setRepeat(repeat);
		newObject.setMaxTime(maxTime);
		newObject.setEndCaption(endCaption);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaCountDownViewProperties();
	}

	@Override
	public void merge(MetaCountDownViewProperties properties) {
		if(style == -1){
			style = properties.getStyle();
		}
		if(stepper == -1){
			stepper = properties.getStepper();
		}
		if(onClick == null){
			onClick = properties.getOnClick();
		}
		if(onFinish == null){
			onFinish = properties.getOnFinish();
		}
		if(repeat == null){
			repeat = properties.isRepeat();
		}
		if(maxTime == -1){
			maxTime = properties.getMaxTime();
		}
		if(endCaption == null){
			endCaption = properties.getEndCaption();
		}
	}
}
