package com.bokesoft.yigo.meta.form.component.control.properties;

import java.util.LinkedList;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.MetaComponentFactory;

public class MetaComboViewProperties extends AbstractMetaObject implements IPropertyMerger<MetaComboViewProperties>{
	
	/** 图标 */
	private String icon = "";
	
	/**图标位置*/
	private Integer iconLocation = IconLocationType.LEFT;
	
	/**主显示组件*/
	private MetaComponent root;

	public MetaComponent getRoot() {
		return root;
	}

	public void setRoot(MetaComponent root) {
		this.root = root;
	}


	public String getIcon() {
		return icon;
	}


	public void setIcon(String icon) {
		this.icon = icon;
	}


	public Integer getIconLocation() {
		return iconLocation;
	}


	public void setIconLocation(Integer iconLocation) {
		this.iconLocation = iconLocation;
	}
	
	public MetaComboViewProperties() {
	}

	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if ( root != null ) {
			list.add(root);
		}
	}

	@Override
	public String getTagName() {
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaComponentFactory factory = MetaComponentFactory.getInstance();
		MetaComponent metaComponent = factory.newComponent(tagName);
		if(metaComponent != null){
			if(root == null){
				root = metaComponent;
				root.preProcessMetaObject(env, doc, node, flag, runType);
			}
		}
		return metaComponent;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaComboViewProperties newObject = (MetaComboViewProperties)newInstance();
		newObject.setIcon(icon);
		newObject.setIconLocation(iconLocation);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaComboViewProperties();
	}

	@Override
	public void merge(MetaComboViewProperties properties) {
		if( this.icon == null ) {
			this.icon = properties.getIcon();
		}
		if(iconLocation == -1){
			this.iconLocation = properties.getIconLocation();
		}
	}
}