package com.bokesoft.yigo.meta.form.component.control.editview;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBarCoderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckListBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaComboBoxProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountUpProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimeCountDownProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaEmptyProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaIconProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMonthPickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNoticeBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberInfoEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPasswordEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPriceLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaProgressIndicatorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaScoreBarProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSegmentedControlProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSeparatorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSwitchProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUTCDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaVideoPlayerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaWizardListProperties;

public class MetaEditViewColumn extends MetaComponent {

	public static final String TAG_NAME = "EditViewColumn";

	/** 列的标识 */
//	private String key = "";
	/** 列的名称 */
//	private String caption = "";
	/** 列宽 */
//	private DefSize width = DefSize.parse("75px");
	/** 文本是否折行显示*/
	private Boolean wrapText = false;
	/** 是否选择字段*/	
	private Boolean isSelect = false;
	/** 是否单选*/
	private Boolean singleSelect = false;
	/** 是否可排序*/
	private Boolean sortable = false;
	/** 数据表标识　*/
	private String tableKey = "";
	/** 数据列标识 */
	private String columnKey = "";
	/** 列类型 */
	private Integer columnType = ControlType.LABEL;
	/** 默认值 */
	private String defaultValue = "";
	/** 默认值公式 */
	private String defaultFormulaValue = "";
	/** 属性值对象 */
	private AbstractMetaObject properties = null;
//	/** 可见性 */
//	private String visible = "";
//	/** 可用性 */
//	private String enable = "";
//	/** 数据绑定，在EditViewColumn中使用时只用于定义事件，不包括数据绑定 */
//	private MetaDataBinding dataBinding = null;
//	/** 格式对象*/
//	private MetaFormat metaFormat = null; 
	
	public MetaEditViewColumn() {
		super();
	}

	public void setProperties(AbstractMetaObject properties) {
		this.properties = properties;
	}

	@Override
	public AbstractMetaObject getProperties() {
		if( properties == null ){
			ensureProperties();
		}
		return this.properties;
	}
	
	@Override
	public int getElementType() {
		return getColumnType();
	}

	public void ensureProperties() {
		if (properties == null) {
			switch (columnType) {
			case ControlType.LABEL:
				this.properties = new MetaLabelProperties();
				break;
			case ControlType.PRICELABEL:
				this.properties = new MetaPriceLabelProperties();
				break;
			case ControlType.RELATIVETIME:
				this.properties = new MetaRelativeTimeProperties();
				break;
			case ControlType.CHECKBOX:
				this.properties = new MetaCheckBoxProperties();
				break;
			case ControlType.HYPERLINK:
				this.properties = new MetaHyperLinkProperties();
				break;
			case ControlType.BUTTON:
			case ControlType.IMAGEBUTTON:
				this.properties = new MetaButtonProperties();
				break;
			case ControlType.NOTICEBAR:
				this.properties = new MetaNoticeBarProperties();
				break;
			case ControlType.BARCODER:
				this.properties = new MetaBarCoderProperties();
				break;
			case ControlType.TOGGLEBUTTON:
				this.properties = new MetaToggleButtonProperties();
				break;
			case ControlType.MULTISTATEBUTTON:
				this.properties = new MetaMultiStateButtonProperties();
				break;
			case ControlType.TEXTEDITOR:
				this.properties = new MetaTextEditorProperties();
				break;
			case ControlType.TEXTBUTTON:
				this.properties = new MetaTextButtonProperties();
				break;
			case ControlType.NUMBEREDITOR:
				this.properties = new MetaNumberEditorProperties();
				break;
			case ControlType.DICT:
			case ControlType.COMPDICT:
			case ControlType.DYNAMICDICT:
				this.properties = new MetaDictProperties();
				break;
			case ControlType.DATEPICKER:
				this.properties = new MetaDatePickerProperties();
				break;
			case ControlType.UTCDATEPICKER:
				this.properties = new MetaUTCDatePickerProperties();
				break;
			case ControlType.COMBOBOX:
				this.properties = new MetaComboBoxProperties();
				break;
			case ControlType.CHECKLISTBOX:
				this.properties = new MetaCheckListBoxProperties();
				break;
			case ControlType.IMAGE:
				this.properties = new MetaImageProperties();
				break;
			case ControlType.VIDEOPLAYER:
				this.properties = new MetaVideoPlayerProperties();
				break;
			case ControlType.STEPEDITOR:
				this.properties = new MetaStepEditorProperties();
				break;
			case ControlType.ICON:
				this.properties = new MetaIconProperties();
				break; 
			case ControlType.TEXTAREA:
				this.properties = new MetaTextAreaProperties();
				break;
			case ControlType.PASSWORDEDITOR:
				this.properties = new MetaPasswordEditorProperties();
				break;
			case ControlType.NUMBERINFOEDITOR:
				this.properties = new MetaNumberInfoEditorProperties();
				break;
			case ControlType.SCOREBAR:
				this.properties = new MetaScoreBarProperties();
				break;
			case ControlType.SWITCH:
				this.properties = new MetaSwitchProperties();
				break;
			case ControlType.SEGMENTEDCONTROL:
				this.properties = new MetaSegmentedControlProperties();
				break;
			case ControlType.PROGRESSINDICATOR:
				this.properties = new MetaProgressIndicatorProperties();
				break;
			case ControlType.PROGRESSBAR:
				this.properties = new MetaProgressBarProperties();
				break;
			case ControlType.SLIDER:
				this.properties = new MetaSliderProperties();
				break;
			case ControlType.COUNTDOWNVIEW:
				this.properties = new MetaCountDownViewProperties();
				break;
			case ControlType.GIFIMAGE:
				this.properties = new MetaGIFImageProperties();
				break;
			case ControlType.IMAGELIST:
				this.properties = new MetaImageListProperties();
				break;
			case ControlType.EMPTY:
				this.properties = new MetaEmptyProperties();
				break;
			case ControlType.MONTHPICKER:
				this.properties = new MetaMonthPickerProperties();
				break;
			case ControlType.TIMEPICKER:
				this.properties = new MetaTimePickerProperties();
				break;
			case ControlType.COUNTUP:
				this.properties = new MetaCountUpProperties();
				break;
			case ControlType.WIZARDLIST:
				this.properties = new MetaWizardListProperties();
				break;
			case ControlType.SEPARATOR:
				this.properties = new MetaSeparatorProperties();
				break;
			case ControlType.TIMECOUNTDOWN:
				this.properties = new MetaTimeCountDownProperties();
				break;
			default:
				throw new RuntimeException("EditView 中 不支持的控件类型:"
						+ ControlType.toString(columnType));
			}
		}
	}

//	public String getVisible() {
//		return visible;
//	}
//
//	public void setVisible(String visible) {
//		this.visible = visible;
//	}

//	/**
//	 * 设置数据绑定
//	 * @param dataBinding 数据绑定
//	 */
//	public void setDataBinding(MetaDataBinding dataBinding) {
//		this.dataBinding = dataBinding;
//	}
//	
//	/**
//	 * 取得数据绑定
//	 * @return 数据绑定
//	 */
//	public MetaDataBinding getDataBinding() {
//		return this.dataBinding;
//	}

//	public String getEnable() {
//		return enable;
//	}
//
//	public void setEnable(String enable) {
//		this.enable = enable;
//	}

	public Boolean isSelect() {
		return isSelect;
	}

	public void setSelect(Boolean isSelect) {
		this.isSelect = isSelect;
		if( isSelect != null && isSelect ) {
			columnType = ControlType.CHECKBOX;
		}
	}
	
	/**
	 * 获取是否可排序
	 * @return 标志
	 */
	public Boolean isSortable() {
		return sortable;
	}

	/**
	 * 设置是否可排序
	 * @param sortable 标志
	 */
	public void setSortable(Boolean sortable) {
		this.sortable = sortable;
	}

	/**
	 * 获取选择字段是否单选
	 * @return 是否单选
	 */
	public Boolean singleSelect() {
		return this.singleSelect;
	}

	/**
	 * 设置选择字段是否单选
	 * @param singleSelect 标志
	 */
	public void setSingleSelect(Boolean singleSelect) {
		this.singleSelect = singleSelect;
	}

//	/**
//	 * 设置列宽
//	 * 
//	 * @param width
//	 *            列宽
//	 */
//	public void setWidth(DefSize width) {
//		this.width = width;
//	}
//
//	/**
//	 * 取得列宽
//	 * 
//	 * @return 列宽
//	 */
//	public DefSize getWidth() {
//		return width;
//	}

	/**
	 * 文本是否折行显示
	 * @return 是否折行显示
	 */
	public Boolean isWrapText() {
		return this.wrapText;
	}

	/**
	 * 设置是否折行显示
	 * @param wrapText 是否折行显示
	 */
	public void setWrapText(Boolean wrapText) {
		this.wrapText = wrapText;
	}

//	/**
//	 * 设置列的名称
//	 * 
//	 * @param caption
//	 *            列的名称
//	 */
//	public void setCaption(String caption) {
//		this.caption = caption;
//	}
//
//	/**
//	 * 取得列的名称
//	 * 
//	 * @return 列的名称
//	 */
//	public String getCaption() {
//		return caption;
//	}

	/**
	 * 设置数据列标识
	 * 
	 * @param columnKey 数据列标识
	 */
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	
	/**
	 * 取得数据列标识
	 * 
	 * @return 数据列标识
	 */
	@Deprecated
	public String getColumnKey() {
		return this.columnKey;
	}

	/**
	 * 设置数据列标识
	 * 
	 * @param columnKey 数据列标识
	 */
	public void setDataColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	
	
	/**
	 * 取得数据列标识
	 * 
	 * @return 数据列标识
	 */
	public String getDataColumnKey() {
		return this.columnKey;
	}
//	/**
//	 * 设置列标识
//	 * 
//	 * @param key
//	 *            列标识
//	 */
//	public void setKey(String key) {
//		this.key = key;
//	}
//
//	/**
//	 * 取得列标识
//	 * 
//	 * @return 列标识
//	 */
//	public String getKey() {
//		return key;
//	}

	/**
	 * 设置列类型
	 * 
	 * @param columnType
	 *            列类型
	 */
	public void setColumnType(Integer columnType) {
		this.columnType = columnType;
	}

	/**
	 * 取得列类型
	 * 
	 * @return 列类型
	 */
	public Integer getColumnType() {
		return this.columnType;
	}

	/**
	 * 设置默认值
	 * 
	 * @param defaultValue
	 *            默认值
	 */
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	/**
	 * 取得默认值
	 * 
	 * @return 默认值
	 */
	public String getDefaultValue() {
		if(this.dataBinding != null && !this.dataBinding.getDefaultValue().isEmpty()){
			return this.dataBinding.getDefaultValue();
		}
		return this.defaultValue;
	}

	/**
	 * 设置默认值表达式
	 * 
	 * @param defaultFormulaValue
	 *            默认值表达式
	 */
	public void setDefaultFormulaValue(String defaultFormulaValue) {
		this.defaultFormulaValue = defaultFormulaValue;
	}

	/**
	 * 取得默认值表达式
	 * 
	 * @return 默认值表达式
	 */
	public String getDefaultFormulaValue() {
		if(this.dataBinding != null && !this.dataBinding.getDefaultFormulaValue().isEmpty()){
			return this.dataBinding.getDefaultFormulaValue();
		}
		return this.defaultFormulaValue;
	}
	
	public void setTableKey(String tableKey){
		this.tableKey = tableKey;
	}
	
	@Override
	public String getTableKey() {
		return this.tableKey;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaEditViewColumn newObject = (MetaEditViewColumn)super.clone();
//		newObject.setKey(key);
//		newObject.setCaption(caption);
//		newObject.setWidth(width);
		newObject.setWrapText(wrapText);
		newObject.setColumnKey(columnKey);
		newObject.setTableKey(tableKey);
		newObject.setColumnType(columnType);
		newObject.setDefaultValue(defaultValue);
		newObject.setDefaultFormulaValue(defaultFormulaValue);
//		newObject.setMetaFormat(metaFormat == null ? null : (MetaFormat)metaFormat.clone());

		newObject.setProperties(properties == null ? null : properties.clone());
//		newObject.setEnable(enable);
//		newObject.setVisible(visible);
		newObject.setSortable(sortable);
//		newObject.setDataBinding(dataBinding == null ? null : (MetaDataBinding)dataBinding.clone());
		
		newObject.setSelect(isSelect);
		newObject.setSingleSelect(singleSelect);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEditViewColumn();
	} 
	
//	public final MetaFormat getMetaFormat() {
//		return metaFormat;
//	}
//
//	public final void setMetaFormat(MetaFormat metaFormat) {
//		this.metaFormat = metaFormat;
//	}
//	
//	public MetaFormat ensureFormat() {
//		if( metaFormat == null ) {
//			metaFormat = new MetaFormat();
//		}
//		return metaFormat;
//	}

	@Override
	public boolean hasDataBinding() {
		return columnKey != null && !columnKey.isEmpty();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
//		if(this.properties != null){
//			this.properties.doPostProcess(flag, callback);
//		}
		
		MetaDataBinding binding = ensureDataBinding();
		if(binding.getColumnKey() == null || binding.getColumnKey().isEmpty()){
			binding.setColumnKey(columnKey);
		}
		if(binding.getDefaultFormulaValue() == null || binding.getDefaultFormulaValue().isEmpty()){
			binding.setDefaultFormulaValue(defaultFormulaValue);
		}
		if (binding.getDefaultValue() == null || binding.getDefaultValue().isEmpty()) {
			binding.setDefaultValue(defaultValue);
		}
		if(binding.getTableKey() == null || binding.getTableKey().isEmpty()){
			binding.setTableKey(tableKey);
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void merge(MetaComponent metaColumn) {
		super.merge(metaColumn);
//		if( this.caption == null ) {
//			this.caption = metaColumn.getCaption();
//		}
//		if( this.width == null ) {
//			this.width = metaColumn.getWidth() == null ? null : metaColumn.getWidth().clone();
//		}
		if( this.wrapText == null ) {
			this.wrapText = ((MetaEditViewColumn)metaColumn).isWrapText();
		}
		if( this.isSelect == null ) {
			this.isSelect = ((MetaEditViewColumn)metaColumn).isSelect();
		}
		if( this.singleSelect == null ) {
			this.singleSelect = ((MetaEditViewColumn)metaColumn).singleSelect();
		}
		if( this.sortable == null ) {
			this.sortable = ((MetaEditViewColumn)metaColumn).isSortable();
		}
		if( this.tableKey == null ) {
			this.tableKey = metaColumn.getTableKey();
		}
		if( this.columnKey == null ) {
			this.columnKey = ((MetaEditViewColumn)metaColumn).getDataColumnKey();
		}
		if( this.defaultValue == null ) {
			this.defaultValue = metaColumn.getDefaultValue();
		}
		if( this.defaultFormulaValue == null ) {
			this.defaultFormulaValue = metaColumn.getDefaultFormulaValue();
		}
//		if( this.visible == null ) {
//			this.visible = metaColumn.getVisible();
//		}
//		if( this.enable == null ) {
//			this.enable = metaColumn.getEnable();
//		}
		
//		MetaDataBinding extBinding = metaColumn.getDataBinding();
//		if( this.dataBinding == null ) {
//			if( extBinding != null ) {
//				this.dataBinding = (MetaDataBinding)extBinding.clone();
//			}
//		} else {
//			if( extBinding != null ) {
//				this.dataBinding.merge(extBinding);
//			} else {
//				this.dataBinding.merge(new MetaDataBinding());
//			}
//		}
		
//		if(onlyShow == null){
//			onlyShow = ((MetaEditViewColumn)metaColumn).isOnlyShow();
//		}
//		
//		MetaFormat metaFormat = ((MetaEditViewColumn)metaColumn).getMetaFormat();
//		if( metaFormat != null ) {
//			if( this.metaFormat == null ) {
//				this.metaFormat = (MetaFormat) metaFormat.clone();
//			} else {
//				this.metaFormat.merge(metaFormat);
//			}
//		}
		
		AbstractMetaObject metaProperties = ((MetaEditViewColumn)metaColumn).getProperties();
		AbstractMetaObject properties = this.getProperties();
		if( properties != null && metaProperties != null ) {
			((IPropertyMerger<AbstractMetaObject>)properties).merge(metaProperties);				
		} 	
	}

	@Override
	public int getControlType() {
		return ControlType.OTHER;
	}

}
