package com.bokesoft.yigo.meta.form.component.control.dictview;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaDictViewColumnCollection extends GenericKeyCollection<MetaDictViewColumn> implements IPropertyMerger<MetaDictViewColumnCollection> {

	public static final String TAG_NAME = "DictViewColumnCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaDictViewColumn.TAG_NAME)) {
			child = new MetaDictViewColumn();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add((MetaDictViewColumn) child);
		}
		return child;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDictViewColumnCollection newObject = (MetaDictViewColumnCollection) super.clone();
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDictViewColumnCollection();
	}

	@Override
	public void merge(MetaDictViewColumnCollection metaDictViewColumns) {

		for (MetaDictViewColumn metaDictViewColumn : metaDictViewColumns) {

			MetaDictViewColumn viewColumn = this.get(metaDictViewColumn.getKey());
			if (viewColumn != null) {
				viewColumn.merge(metaDictViewColumn);
			} else {//直接添加
				this.add(metaDictViewColumn);
			}
		}
	}
}
