package com.bokesoft.yigo.meta.form.component.control.buttongroup;

import java.util.LinkedList;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.control.MetaToggleButton;

public class MetaButtonCollection extends GenericNoKeyCollection<MetaToggleButton> {
	public MetaButtonCollection() {
		super();
	}

	public static final String TAG_NAME = "ButtonCollection";
	
	/** 按钮点击事件 */
	private MetaBaseScript onClick = null;
	
	/**
	 * 设置按钮点击事件
	 * 
	 * @param onClick
	 *            按钮点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		this.onClick = onClick;
	}

	/**
	 * 获取按钮点击事件
	 * 
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return this.onClick;
	}
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if ( MetaToggleButton.TAG_NAME.equals(tagName) ) {
			MetaToggleButton metaToogleButton = new MetaToggleButton();
			this.add(metaToogleButton);
			resultMetaObject = metaToogleButton;
		}
		if ( MetaConstants.Event_OnClick.equals(tagName) ) {
			onClick = new MetaBaseScript(MetaConstants.Event_OnClick);
			resultMetaObject = onClick;
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaButtonCollection newObj = (MetaButtonCollection)super.clone();
		newObj.setOnClick(onClick == null ? null : (MetaBaseScript)onClick.clone());
		return newObj;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaButtonCollection();
	}

}
