package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;

/**
 * 文本域配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */

public class MetaTextArea extends MetaTextEditor {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_TEXTAREA;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.TEXTAREA;
	}

	@Override
	public MetaTextArea clone() {
		MetaTextArea newObject = (MetaTextArea)super.clone();
		newObject.setProperties(properties == null ? null : getProperties().clone());
		
		return newObject;
	}

	@Override
	public MetaTextArea newInstance() {
		return new MetaTextArea();
	}

	@Override
	public MetaTextAreaProperties getProperties() {
		return (MetaTextAreaProperties) properties;
	}

	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaTextAreaProperties) properties;
	}

	@Override
	public MetaTextEditorProperties newProperties() {
		return new MetaTextAreaProperties();
	}
}

