package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaGIFImageProperties;

/**
 * GIF动图组件
 * @author chenzs
 *
 */
public class MetaGIFImage extends MetaComponent {

	public static final String TAG_NAME = ControlType.STR_GIFIMAGE;

	/** 属性对象*/
	private MetaGIFImageProperties properties = new MetaGIFImageProperties();

	/**
	 * 获取来源类型
	 * @return 来源类型，参考{@link com.bokesoft.yigo.common.def.ImageSourceType}
	 */
	public Integer getSourceType() {
		return properties.getSourceType();
	}

	/**
	 * 设置来源类型
	 * @param sourceType 来源类型，参考{@link com.bokesoft.yigo.common.def.ImageSourceType}
	 */
	public void setSourceType(Integer sourceType) {
		properties.setSourceType(sourceType);
	}

	/**
	 * 获取在类型为Resource时定义图片来源的相对路径
	 * @return 在类型为Resource时定义图片来源的相对路径
	 */
	public String getImage() {
		return properties.getImage();
	}

	/**
	 * 设置在类型为Resource时定义图片来源的相对路径
	 * @param image 在类型为Resource时定义图片来源的相对路径
	 */
	public void setImage(String image) {
		this.properties.setImage(image);
	}

	/**
	 * 获取点击事件
	 * @return 点击事件
	 */
	public MetaBaseScript getOnClick() {
		return properties.getOnClick();
	}

	/**
	 * 设置点击事件
	 * @param onClick 点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		properties.setOnClick(onClick);
	}

	/**
	 * 获取拉伸缩放类型
	 * @return 拉伸缩放类型
 	 */
	public Integer getImageScaleType(){
		return properties.getImageScaleType();
	}
	
	/**
	 * 设置拉伸缩放类型
	 * @param imageScaleType 拉伸缩放类型
	 */
	public void setImageScaleType(Integer imageScaleType){
		properties.setImageScaleType(imageScaleType);
	}
	
	@Override
	public int getControlType() {
		return ControlType.GIFIMAGE;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	/**
	 * 设置属性对象
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaGIFImageProperties) properties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaGIFImage();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaGIFImage newObj = (MetaGIFImage) super.clone();
		newObj.setProperties(properties == null ? null : (MetaGIFImageProperties) properties.clone());
		return newObj;
	}
}
