package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaEmptyProperties;

/**
 * 空组件，仅移动端使用，其主要作用是保存值，用于各种计算，但本身不需要显示在界面上，各个布局属性全都无效
 * @author chenzs
 *
 */
public class MetaEmpty extends MetaComponent{
	
	public static final String TAG_NAME = ControlType.STR_EMPTY;
	
	/** 属性对象*/
	private MetaEmptyProperties properties = new MetaEmptyProperties();

	@Override
	public int getControlType() {
		return ControlType.EMPTY;
	}

	@Override
	public AbstractMetaObject getProperties() {
		return properties;
	}

	/**
	 * 设置属性对象
	 * @param properties 属性对象
	 */
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaEmptyProperties) properties;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaEmpty metaEmpty = (MetaEmpty) super.clone();
		metaEmpty.setProperties(properties == null ? null : (MetaEmptyProperties)properties.clone());
		return metaEmpty;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEmpty();
	}

}
