package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.CountDownViewStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;


/**
 * 倒计时组件配置对象
 *
 * Created by wangfeng on 2017/11/16.
 */

public class MetaCountDownView extends MetaComponent{
	
	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_COUNTDOWNVIEW;
	
	/** 属性对象*/
	private MetaCountDownViewProperties metaProperties;
	
	public MetaCountDownView() {
		metaProperties = new MetaCountDownViewProperties();
	}

	/**
	 * 设置属性对象
	 *
	 * @param metaProperties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject metaProperties) {
		this.metaProperties = (MetaCountDownViewProperties) metaProperties;
	}
	
	@Override
	public int getControlType() {
		return ControlType.COUNTDOWNVIEW;
	}

	@Override
	public MetaCountDownViewProperties getProperties() {
		return metaProperties;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public MetaCountDownView newInstance() {
		return new MetaCountDownView();
	}

	@Override
	public MetaCountDownView clone() {
		MetaCountDownView metaObject = (MetaCountDownView)super.clone();
		metaObject.setProperties(metaProperties == null ? null : metaProperties.clone());
		return metaObject;
	}

	/**
	 * 获取最大值
	 *
	 * @return 最大值
	 */
	public Integer getMaxTime() {
		return metaProperties.getMaxTime();
	}

	/**
	 * 设置最大值
	 *
	 * @param maxTime 最大值
	 */
	public void setMaxTime(Integer maxTime) {
		metaProperties.setMaxTime(maxTime);
	}

	/**
	 * 获取是否重复
	 *
	 * @return 是否重复
	 */
	public Boolean isRepeat() {
		return metaProperties.isRepeat();
	}

	/**
	 * 设置是否重复
	 *
	 * @param repeat 是否重复
	 */
	public void setRepeat(Boolean repeat) {
		metaProperties.setRepeat(repeat);
	}

	/**
	 * 获取显示样式
	 *
	 * @return 显示样式，取值范围为{@link CountDownViewStyle}
	 */
	public Integer getStyle() {
		return metaProperties.getStyle();
	}

	/**
	 * 设置显示样式
	 *
	 * @param style 显示样式，取值范围为{@link CountDownViewStyle}
	 */
	public void setStyle(Integer style) {
		metaProperties.setStyle(style);
	}

	/**
	 * 获取步进值
	 *
	 * @return 步进值（以秒为单位）
	 */
	public Integer getStepper() {
		return metaProperties.getStepper();
	}

	/**
	 * 设置步进值
	 *
	 * @param stepper 步进值（以秒为单位）
	 */
	public void setStepper(Integer stepper) {
		metaProperties.setStepper(stepper);
	}

	/**
	 * 获取计时结束事件
	 *
	 * @return 计时结束事件
	 */
	public MetaBaseScript getOnFinish() {
		return metaProperties.getOnFinish();
	}

	/**
	 * 设置计时结束事件
	 *
	 * @param onFinish 计时结束事件
	 */
	public void setOnFinish(MetaBaseScript onFinish) {
		metaProperties.setOnFinish(onFinish);
	}

	/**
	 * 获取计时点击事件
	 *
	 * @return 计时点击事件
	 */
	public MetaBaseScript getOnClick() {
		return metaProperties.getOnClick();
	}

	/**
	 * 设置计时点击事件
	 *
	 * @param onClick 计时点击事件
	 */
	public void setOnClick(MetaBaseScript onClick) {
		metaProperties.setOnClick(onClick);
	}

	/**
	 * 获取结束时显示文本
	 *
	 * @return 结束时显示文本
	 */
	public String getEndCaption() {
		return metaProperties.getEndCaption();
	}

	/**
	 * 设置结束时显示文本
	 *
	 * @param endCaption 结束时显示文本
	 */
	public void setEndCaption(String endCaption) {
		metaProperties.setEndCaption(endCaption);
	}
}
