package com.bokesoft.yigo.meta.form.component.control;

import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCheckBoxProperties;

/**
 * 复选框配置对象
 * 
 * @author chenzs
 * @since YES1.0
 */

public class MetaCheckBox extends MetaComponent {

	/** 配置文件中对应的节点的标签名称 */
	public static final String TAG_NAME = ControlType.STR_CHECKBOX;
	
	/** 属性对象 */
	private MetaCheckBoxProperties properties = new MetaCheckBoxProperties();
 
	/**
	 * 设置属性对象
	 *
	 * @param properties 属性对象
	 */
	@Override
	public void setProperties(AbstractMetaObject properties) {
		this.properties = (MetaCheckBoxProperties) properties;
	}
	
	@Override
	public MetaCheckBoxProperties getProperties() {
		return this.properties;
	}

	/**
	 * 设置默认图标
	 *
	 * @param icon 默认图标
	 */
	public void setIcon(String icon) {
		properties.setIcon(icon);
	}

	/**
	 * 获取默认图标
	 *
	 * @return 默认图标
	 */
	public String getIcon() {
		return properties.getIcon();
	}

	/**
	 * 设置选中图标
	 *
	 * @param selectedIcon 选中图标
	 */
	public void setSelectedIcon(String selectedIcon) {
		properties.setSelectedIcon(selectedIcon);
	}

	/**
	 * 获取选中图标
	 *
	 * @return 选中图标
	 */
	public String getSelectedIcon() {
		return properties.getSelectedIcon();
	}

	/**
	 * 设置图标位置，仅{@link #getIcon()}或{@link #getSelectedIcon()}不为空时有效
	 *
	 * @param iconLocation 图标位置
	 */
	public void setIconLocation(Integer iconLocation) {
		properties.setIconLocation(iconLocation);
	}

	/**
	 * 获取图标位置，仅{@link #getIcon()}或{@link #getSelectedIcon()}不为空时有效
	 *
	 * @return 图标位置
	 */
	public Integer getIconLocation() {
		return properties.getIconLocation();
	}
	
	/**
	 * 设置是否隐藏图标按钮
	 * @param isHideButton 是否隐藏图标按钮
	 */ 
	public void setHideButton(Boolean  isHideButton){
		properties.setHideButton(isHideButton);
	}
	
	/**
	 * 获取是否显示图标按钮
	 * @return
	 */
	public Boolean getIsHideButton(){
		return properties.getIsHideButton();
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getControlType() {
		return ControlType.CHECKBOX;
	}
	
	@Override
	public MetaCheckBox clone() {
		MetaCheckBox newObject = (MetaCheckBox)super.clone();
		newObject.setProperties(properties == null ? null : properties.clone());

		return newObject;
	}

	@Override
	public MetaCheckBox newInstance() {
		return new MetaCheckBox();
	}
}
