package com.bokesoft.yigo.meta.form.component;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

public class MetaFont extends AbstractMetaObject implements IPropertyMerger<MetaFont>{
    /** 字体名称 */
    private String name = "";
    /** 字体大小 */
    private Integer size = -1;
    /** 是否粗体 */
    private Boolean bold = false;
    /** 是否斜体 */
    private Boolean italic = false;
    /**
     * 是否下划线
     */
    private Boolean underline = false;
    /**
     * 下划线颜色
     */
    private String underlineColor = "";

    public MetaFont() {
        super();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        // TODO Auto-generated method stub

    }

    public Boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(Boolean underline) {
        this.underline = underline;
    }

    public String getUnderlineColor() {
        return underlineColor;
    }

    public void setUnderlineColor(String underlineColor) {
        this.underlineColor = underlineColor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return size;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public Boolean isBold() {
        return this.bold;
    }

    public Boolean getBold(){
        return bold;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public Boolean isItalic() {
        return this.italic;
    }

    public Boolean getItalic(){
        return italic;
    }

    public static final String TAG_NAME = "Font";

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
                                                    Object node, String tagName, Object flag, int runType) throws MetaException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public AbstractMetaObject clone() {
        MetaFont newObject = new MetaFont();
        newObject.setName(name);
        newObject.setSize(size);
        newObject.setBold(bold);
        newObject.setItalic(italic);
        newObject.setUnderline(underline);
        newObject.setUnderlineColor(underlineColor);

        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaFont();
    }

    public boolean isDefault() {
        return name.isEmpty() && size == -1 && bold == null && italic == null;
    }

    @Override
    public void merge(MetaFont meta) {
        if( this.name == null ) {
            this.name = meta.getName();
        }
        if( this.size == -1 ) {
            this.size = meta.getSize();
        }
        if( this.bold == null ) {
            this.bold = meta.getBold();
        }
        if( this.italic == null ) {
            this.italic = meta.getItalic();
        }
        if( this.underline == null ) {
            this.underline = meta.isUnderline();
        }
        if( this.underlineColor == null ) {
            this.underlineColor = meta.getUnderlineColor();
        }
    }

}