package com.bokesoft.yigo.meta.form;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaUICheckRule extends MetaBaseScript {
	public MetaUICheckRule() {
		super(TAG_NAME);
	}
	
	private String key = "";

	/** 描述 */
	private String description = "";
	/** 错误描述 */
	private String errorInfo = "";
	/** 字符串标识 */
	private String stringID = "";
	/** 目标组件，在通配表达式中定义目标组件 */
	private String target = "";
	/** 依赖*/
	private String dependency = "";

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
	}

	public static final String TAG_NAME = "UICheckRule";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaUICheckRule newObject = (MetaUICheckRule)super.clone();
		newObject.setDescription(description);
		newObject.setErrorInfo(errorInfo);
		newObject.setStringID(stringID);
		newObject.setTarget(target);
		newObject.setDependency(dependency);

		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaUICheckRule();
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置描述
	 * @param description 描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得描述
	 * @return 描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置错误描述
	 * @param errorInfo 错误描述
	 */
	public void setErrorInfo(String errorInfo) {
		this.errorInfo = errorInfo;
	}
	
	/**
	 * 取得错误描述
	 * @return 错误描述
	 */
	public String getErrorInfo() {
		return this.errorInfo;
	}

	/**
	 * 设置字符串标识
	 * @param stringID 字符串标识
	 */
	public void setStringID(String stringID) {
		this.stringID = stringID;
	}
	
	/**
	 * 取得字符串标识
	 * @return 字符串标识
	 */
	public String getStringID() {
		return this.stringID;
	}

	/**
	 * 获取依赖
	 * @return
	 */
	public String getDependency() {
		return dependency;
	}

	/**
	 * 设置依赖
	 * @param dependency
	 */
	public void setDependency(String dependency) {
		this.dependency = dependency;
	}
	
	/**
	 * 设置目标
	 * @param target 目标组件标识，为空或者为表格的标识
	 */
	public void setTarget(String target) {
		this.target = target;
	}
	
	/**
	 * 取得目标
	 * @return 目标组件标识
	 */
	public String getTarget() {
		return this.target;
	}
	
}
