package com.bokesoft.yigo.meta.flatcanvas.convertor.json;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.flatcanvas.convertor.IContentHandler;
import com.bokesoft.yigo.meta.flatcanvas.convertor.INode;

/**
 * 配置对象的json格式转储
 * 
 * @author chenbinbin
 *
 */
public class JsonContentHandler implements IContentHandler {
	
	private static final String __ROOT__ = "__root__";
	
	private INode root = null;
	
	public JsonContentHandler() {
		root = new JsonNode(__ROOT__, new JSONObject());
	}

	@Override
	public INode createNode(String tagName, boolean isCollection) {
		return new JsonNode(tagName, isCollection ?  new JSONArray() : new JSONObject());
	}

	@Override
	public INode getRoot() {
		return root;
	}

	@Override
	public String getContent() {
		JSONObject rootData = (JSONObject) root.getData();
		return rootData.toString();
	}

}
