package com.bokesoft.yigo.meta.factory.workflow.source;

import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;

import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaProcessLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.ProcessDefinitionProfile;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class ProcessDefinationDirectory implements IProcessSource {

	private HashMap<String, IMetaResolver> projectResolverMap = null;
	private ProcessDefinitionProfile profile = null;
	
	public ProcessDefinationDirectory(HashMap<String, IMetaResolver> projectResolverMap, ProcessDefinitionProfile profile) {
		this.projectResolverMap = projectResolverMap;
		this.profile = profile;
	}
	
	@Override
	public MetaProcess loadProcess(JSONObject definationJson) throws Throwable {
		MetaProcess metaProcess = null;
		MetaProcessLoad load = new MetaProcessLoad(AppRunType.App);
		MetaProject metaProject = (MetaProject) profile.getProject();
		IMetaResolver projectResourceResolver = projectResolverMap.get(metaProject.getKey());
		if( projectResourceResolver == null ) {
			throw new MetaException(MetaException.PROJECT_RESOLVER_UNDEFINED, 
					SimpleStringFormat.format(StringTable.getString(null, "", StringTable.ProjectResolverUndefined), metaProject.getKey()));
		}
		String resource[] = profile.getResource().split(Matcher.quoteReplacement(File.separator), 2);
		load.load(projectResourceResolver, resource[1]);
		metaProcess = (MetaProcess) load.getRootMetaObject();
		return metaProcess;
	}

}
