package com.bokesoft.yigo.meta.factory.workflow.source;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.bpm.process.IJsonUnserializer;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;

public class ProcessDefinationDB implements IProcessSource {
	
	private IJsonUnserializer jsonUnserializer = null;
	
	public ProcessDefinationDB(IJsonUnserializer jsonUnserializer) {
		this.jsonUnserializer = jsonUnserializer;
	}
	
	@Override
	public MetaProcess loadProcess(JSONObject definationJson) throws Throwable{
		MetaProcess process = null;
		if(definationJson != null){
			if(jsonUnserializer != null){
				process = jsonUnserializer.unserialize(definationJson);
			}
		}
		return process;
	}

}
