package com.bokesoft.yigo.meta.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

import com.bokesoft.yigo.meta.base.IMetaResolver;

public class FileResourceResolver implements IMetaResolver {
	public String path = "";
	public FileResourceResolver(String path) {
		this.path = path;
	}
	
	@Override
	public boolean isListAbsolutePath() {
		return false;
	}

	@Override
	public InputStream read(String resource, int type) throws Exception {
		File f = new File(path);
		if (f.isDirectory() || !f.exists()) {
			return null;
		}
		return new FileInputStream(f);
	}

	@Override
	public URI getURI(String resource, int type) throws Exception {
		return null;
	}

	@Override
	public boolean write(String resource, byte[] data) throws Exception {
		return false;
	}

	@Override
	public String getPath(String resource) {
		return null;
	}

	@Override
	public int listResource(String resource, String flag, List<String> resources, List<String> names,
			List<Boolean> flags) throws Exception {
		return 0;
	}

	@Override
	public char getSeparator() {
		return File.separatorChar;
	}

}
