package com.bokesoft.yigo.meta.diff;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.diff.impl.IMergeDiffAction;
import com.bokesoft.yigo.meta.diff.util.DiffActionManager;
import com.bokesoft.yigo.meta.diff.util.DiffKeyUtil;

public class MetaDiffNode extends KeyPairMetaObject {
	
	public final static String TAG_NAME = "DiffNode";
	
	private String key = null;
	
	private MetaAddCollection addCollection = null;
	
	private MetaDeleteCollection deleteCollection = null;
	
	private MetaUpdateCollection updateCollection = null;
	
	private MetaMoveCollection moveCollection = null;
	
	// 子差异对象集合
	private MetaDiffNodeCollection childDiffNodeCollection  = null;
	
	private AbstractMetaObject meta = null;
	
	private boolean isChanged = false;
	
	private List<String> deleteAttrs = null;
	
	public MetaDiffNode() {
		deleteAttrs = new ArrayList<String>();
	}
	
	public MetaDiffNode(String baseKey, AbstractMetaObject meta, AbstractMetaObject parent, AbstractMetaObject  grandParent) {
		this.meta = meta;
		deleteAttrs = new ArrayList<String>();
		setKey(DiffKeyUtil.getDiffKey(baseKey, meta, parent, grandParent));
 	}
	
	public void setDeleteAttrs(String deleteAttrs) {
		this.deleteAttrs.clear();
		if (!StringUtil.isBlankOrNull(deleteAttrs)) {
			String[] attrNames = StringUtil.split(deleteAttrs, "|");
			for (String attrName : attrNames) {
				this.deleteAttrs.add(attrName);
			}
		}
	}
	
	public String getDeleteAttrs() {
		return StringUtil.join("|", deleteAttrs.iterator());
	}
	
	public List<String> getDeleteAttrList() {
		return this.deleteAttrs;
	}
	
	public void addDeleteAttr(String attrName) {
		this.deleteAttrs.add(attrName);
	}
	
	public boolean isDeleteAttr(String attrName) {
		return deleteAttrs.contains(attrName);
	}
	
	public void removeDeleteAttr(String attrName) {
		this.deleteAttrs.remove(attrName);
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}

	public void markChanged() {
		this.isChanged = true;
	}
	
	public boolean isChanged() {
		return this.isChanged;
	}
	
	public AbstractMetaObject getMeta() {
		return meta;
	}
	
/*	// 需要生成顺序的节点集合,避免开始所有集合类型全部生成导致错误,需要顺序的添加进去,后面删除
	private static List<String> tagNames = Arrays.asList(
			MetaGridCell.TAG_NAME,
			MetaGridColumn.TAG_NAME,
			MetaGridRow.TAG_NAME,
			MetaOperation.TAG_NAME,
			MetaOperationCollection.TAG_NAME
		);*/
	
	/**
	 * 记录新增项
	 * @param child 子项
	 * @param index 子项所在位置
	 */
/*	public void recordAdd(String key, AbstractMetaObject child, int index) {
		if (this.addCollection == null) {
			this.addCollection = new MetaAddCollection();
		}
		MetaAdd metaAdd = new MetaAdd(key, index);
		metaAdd.setBase(child);
		this.addCollection.add(metaAdd);
		this.markChanged();
	}*/
	
	/**
	 * 记录新增项
	 * @param key
	 * @param containerTag
	 * @param containerKey
	 * @param child
	 */
	public void recordAdd(String key, String previousKey, String containerTag, String containerKey, AbstractMetaObject child) {
		if (this.addCollection == null) {
			this.addCollection = new MetaAddCollection();
		}
		MetaAdd metaAdd = new MetaAdd(key);
		metaAdd.setContainerKey(containerKey);
		metaAdd.setContainerTag(containerTag);
		metaAdd.setPreviousKey(previousKey);
		metaAdd.setBase(child);
		this.addCollection.add(metaAdd);
		this.markChanged();
	}
	
	
	public void recordAdd(KeyPairMetaObject child) {
		recordAdd(child.getKey(), "", "", "", child);
	}
	
	/**
	 * 记录删除项 
	 * @param meta 子项
	 * @param index 子项所在位置
	 */
	public void recordDelete(String key, AbstractMetaObject meta, AbstractMetaObject parentMeta) {
		if (this.deleteCollection == null) {
			this.deleteCollection = new MetaDeleteCollection();
		}
		String parentTag = (parentMeta == null ? "" : parentMeta.getTagName());
		this.deleteCollection.add(new MetaDelete(key, meta.getTagName(), parentTag));
		this.markChanged();
	}
	
	public void recordDelete(KeyPairMetaObject meta, AbstractMetaObject parentMeta) {
		recordDelete(meta.getKey(), meta, parentMeta);
	}
	
	public void recordMove(MetaMove move) {
		if (this.moveCollection == null) {
			this.moveCollection = new MetaMoveCollection();
		}
		this.moveCollection.add(move);
		this.markChanged();
	}
	
	public void addDiffNode(MetaDiffNode diffNode) {
		if (diffNode.isChanged) {
			if (this.childDiffNodeCollection == null) {
				this.childDiffNodeCollection = new MetaDiffNodeCollection();
			}
			this.childDiffNodeCollection.add(diffNode);
		}
	}
	
	
	/**
	 * 记录更新项
	 * 
	 * 更新项
	 * @param item
	 */
	public void recordUpdate(AbstractMetaObject item) {
		if (this.updateCollection == null) {
			this.updateCollection = new MetaUpdateCollection();
		}
		this.updateCollection.add(item);
		this.markChanged();
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(meta);
		list.add(addCollection);
		list.add(updateCollection);
		list.add(deleteCollection);
		list.add(moveCollection);
		list.add(childDiffNodeCollection);
	}

	public void setAddCollection(MetaAddCollection addCollection ) {
		this.addCollection = addCollection;
	}
	
	public void setUpdateCollection(MetaUpdateCollection updateCollection) {
		this.updateCollection = updateCollection;
	}
	
	public void setDeleteCollection(MetaDeleteCollection deleteCollection) {
		this.deleteCollection = deleteCollection;
	}
	
	public void setMoveCollection(MetaMoveCollection moveCollection) {
		this.moveCollection = moveCollection;
	}
	
	private void setChildDiffNodeCollection(MetaDiffNodeCollection childDiffNodeCollection) {
		this.childDiffNodeCollection = childDiffNodeCollection;
	}

	public void setBase(AbstractMetaObject meta) {
		this.meta = meta;
	}
	
	public AbstractMetaObject getBase() {
		return this.meta;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		AbstractMetaObject metaObject = null;
		if (MetaAddCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			this.addCollection = new MetaAddCollection();
			metaObject = addCollection;
		} else if (MetaUpdateCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			this.updateCollection = new MetaUpdateCollection();
			metaObject = updateCollection;
		} else if (MetaDeleteCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			this.deleteCollection = new MetaDeleteCollection();
			metaObject = deleteCollection;
		} else if (MetaMoveCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			this.moveCollection = new MetaMoveCollection();
			metaObject = moveCollection;
		} else if (MetaDiffNodeCollection.TAG_NAME.equalsIgnoreCase(tagName)) {
			this.childDiffNodeCollection = new MetaDiffNodeCollection();
			metaObject = childDiffNodeCollection;
		} else {
			this.meta = (AbstractMetaObject) DiffActionManager.getInstance().createMetaElement(tagName, env);
			this.meta.preProcessMetaObject(env, doc, node, flag, runType);
			metaObject = meta;
		}
		return metaObject;

	}

	@Override
	public AbstractMetaObject clone() {
		MetaDiffNode clone = new MetaDiffNode();
		clone.setAddCollection(addCollection == null ? null : (MetaAddCollection) addCollection.clone());
		clone.setUpdateCollection(updateCollection == null ? null : (MetaUpdateCollection) updateCollection.clone());
		clone.setDeleteCollection(deleteCollection == null ? null : (MetaDeleteCollection) deleteCollection.clone());
		clone.setMoveCollection(moveCollection == null ? null : (MetaMoveCollection) moveCollection.clone());
		clone.setChildDiffNodeCollection(childDiffNodeCollection == null ? null : (MetaDiffNodeCollection) childDiffNodeCollection.clone());
		clone.setBase((KeyPairMetaObject) meta.clone());
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDiffNode();
	}

	public void mergeDiff(IMergeDiffAction mergeAction) throws Exception {
		mergeAction.mergeBase(meta);
		if (updateCollection != null) {
			 for (AbstractMetaObject meta : updateCollection) {
				 mergeAction.mergeUpdate(meta);
			 }
		}
		
		if (deleteCollection != null) {
			for (MetaDelete meta : deleteCollection) {
				 mergeAction.mergeDelete(meta);
			}
		}

		
		if (addCollection != null) {
			for (MetaAdd meta : addCollection) {
				mergeAction.mergeAdd(meta);
			}
/*			MetaIndexCollection mic = addCollection.getIndexCollection();
			for (KeyPairMetaObject meta : addCollection) {
				int index = -1;
				if( mic != null ) {
					MetaIndex metaIndex = mic.get(meta.getKey());
					if( metaIndex != null ) {
						index = metaIndex.getIndex();
					}
				}
				if( index != -1 ) {
					mergeAction.mergeAdd(meta, index);
				} else {
					mergeAction.mergeAdd(meta);
				}
			}*/
		}
		
		// 合并位移差异， 可以单个合并，也可以一起合并
		if (moveCollection != null) {
			boolean result = mergeAction.mergeMoveCollection(moveCollection);
			if (!result) {
				for (MetaMove meta : moveCollection) {
					mergeAction.mergeMove(meta);
				}
			}
		}
		
/*		if (sortCollection != null) {
			 for (MetaSort meta : sortCollection) {
				 mergeAction.mergeSort(meta);
			 }
		}*/
	}

}
