package com.bokesoft.yigo.meta.dataobject;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.common.def.ParameterSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericNoKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaParameterCollection extends GenericNoKeyCollection<MetaParameter> {

	public static final String TAG_NAME = "ParameterCollection";

	private List<String> dependentFields = null;
	
	private List<Integer> dataTypes = null;

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaParameter.TAG_NAME)) {
			resultMetaObject = new MetaParameter();
		}
		resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		this.add((MetaParameter) resultMetaObject);
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaParameterCollection();
	}

	public List<String> getDependedFields() {
		if (dependentFields == null) {
			dependentFields = new ArrayList<String>();
		}
		return dependentFields;
	}

	/**
	 * 返回参数的类型集合
	 * @return 数据类型集合
	 */
	public List<Integer> getDataTypes(){
		return dataTypes;
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject,Boolean> callback) throws MetaException {
		for (MetaParameter parameter : this) {
			if(dataTypes == null){
				dataTypes = new ArrayList<Integer>();
			}
			
			dataTypes.add(parameter.getDataType());

			if (parameter.getSourceType() == ParameterSourceType.FIELD) {
				if (dependentFields == null) {
					dependentFields = new ArrayList<String>();
				}

				// 如果取值类型为字段， 则加入依赖字段集合中
				dependentFields.add(parameter.getFieldKey());
			}
		}
	}
}
