package com.bokesoft.yigo.meta.dataobject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;

public class MetaMigrationCheckScript extends MetaMigrationCheckRule {

	public static final String TAG_NAME = "MigrationCheckScript";

	private MetaBaseScript action = new MetaBaseScript(TAG_NAME);

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMigrationCheckScript clone = new MetaMigrationCheckScript();
		clone.action = (MetaBaseScript) action.clone();
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMigrationCheckScript();
	}

	public void setType(int type) {
		action.setType(type);
	}

	public void setRunType(int runType) {
		action.setRunType(runType);
	}

	public void setContent(String textContent) {
		action.setContent(textContent);
	}

	public int getType() {
		return action.getType();
	}

	public String getContent() {
		return action.getContent();
	}

	public int getRunType() {
		return action.getRunType();
	}

}
