package com.bokesoft.yigo.meta.datamigration.calculate;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

import com.bokesoft.yes.meta.datamigration.calculate.MetaMigrationParas;
import com.bokesoft.yigo.meta.datamigration.DMOpSign;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckRule;
import com.bokesoft.yigo.meta.factory.IMetaFactory;

public class MetaMigrationTableParas {

	/** 迁移表定义 */
	private MetaMigrationTable migrationTable = null;

	/** 直接赋值的数据字段 */
	private TreeMap<String, MetaColumnM> assignColumnMap = new TreeMap<>();

	/** 加值的数据字段 */
	private TreeMap<String, MetaColumnM> addColumnMap = new TreeMap<>();

	public MetaMigrationTableParas(MetaMigrationTable migrationTable) {
		this.migrationTable = migrationTable;
	}

	public void init(MetaDataMigration migration, IMetaFactory factory) throws Throwable {
		MetaMigrationParas paras = migration.getMigrationParas(factory);
		for (MetaColumnM column : migrationTable.getDataColumnList()) {
			MetaDMSourceField sourceField = paras.getFieldMap().get(column.getKey());
			if (sourceField != null) {
				if (sourceField.getOpSign() == DMOpSign.OP_ASSIGN) {
					assignColumnMap.put(column.getKey(), column);
					if (addColumnMap.remove(column.getKey()) != null)
						// TODO报错
						;
				} else {
					addColumnMap.put(column.getKey(), column);
					if (assignColumnMap.remove(column.getKey()) != null)
						// TODO报错
						;
				}

			}
		}
	}

	public TreeMap<String, MetaColumnM> getAssignColumnMap() {
		return assignColumnMap;
	}

	public TreeMap<String, MetaColumnM> getAddColumnMap() {
		return addColumnMap;
	}

	public MetaPeriodColumn getPeriodColumn() {
		return migrationTable.getPeriodColumn();
	}

	public ArrayList<MetaColumnM> getGroupColumnList() {
		return migrationTable.getGroupColumnList();
	}

	public ArrayList<MetaColumnM> getDataColumnList() {
		return migrationTable.getDataColumnList();
	}

	public String getTag() {
		return migrationTable.getTag();
	}

	public int getMigrationUpdateStrategy() {
		return migrationTable.getMigrationUpdateStrategy();
	}

	public List<MetaMigrationCheckRule> getCheckRuleList() {
		return migrationTable.getCheckRuleList();
	}

}
