package com.bokesoft.yigo.meta.datamigration;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.intf.IMetaProject;

/**
 * MetaDataMigrationProfile定义数据迁移的属性，用于扫描文件产生，主要用于惰性加载
 * @author 王元和
 *
 */
public class MetaDataMigrationProfile extends KeyPairMetaObject {
	/** 迁移的标识 */
	private String key = "";
	/** 迁移的名称 */
	private String caption = "";
	/** 迁移的描述 */
	private String description = "";
	/** 源数据对象标识 */
	private String srcDataObjectKey = "";
	/** 目标数据对象标识 */
	private String tgtDataObjectKey = "";
	/** 迁移的状态字段的标识，用于控制整个数据对象的条件 */
	private String statusFieldKey = null;
	/** 迁移发生的状态字段的条件值(字符串表示) */
	private String statusValue = "";
	/** 迁移的数据条件，用于数据单条源数据的条件，表达式定义 */
	private String condition = null;
	/** 资源路径 */
	private String resource = null;
	/** 迁移元数据 */
	private MetaDataMigration dataMigration = null;
	/** 工程引用 */
	private IMetaProject project = null;
	/** 继承的数据迁移标识 */
	private String extend = "";
	public MetaDataMigrationProfile() {
		super();
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置迁移标识
	 * @param key 迁移标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 设置迁移名称
	 * @param caption 迁移名称
	 */
	public void setCaption(String caption) {
		this.caption = caption;
	}
	
	/**
	 * 取得迁移名称
	 * @return 迁移名称
	 */
	public String getCaption() {
		return this.caption;
	}
	
	/**
	 * 设置迁移描述
	 * @param description 迁移描述
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 取得迁移描述
	 * @return 迁移描述
	 */
	public String getDescription() {
		return this.description;
	}
	
	/**
	 * 设置源数据对象标识
	 * @param srcDataObjectKey 源数据对象标识
	 */
	public void setSrcDataObjectKey(String srcDataObjectKey) {
		this.srcDataObjectKey = srcDataObjectKey;
	}
	
	/**
	 * 取得源数据对象标识
	 * @return 源数据对象标识
	 */
	public String getSrcDataObjectKey() {
		return this.srcDataObjectKey;
	}
	
	/**
	 * 设置目标数据对象标识
	 * @param tgtDataObjectKey 目标数据对象标识
	 */
	public void setTgtDataObjectKey(String tgtDataObjectKey) {
		this.tgtDataObjectKey = tgtDataObjectKey;
	}
	
	/**
	 * 取得目标数据对象标识
	 * @return 目标数据对象标识
	 */
	public String getTgtDataObjectKey() {
		return this.tgtDataObjectKey;
	}
	
	/**
	 * 设置状态字段标识
	 * @param statusFieldKey 状态字段标识
	 */
	public void setStatusFieldKey(String statusFieldKey) {
		this.statusFieldKey = statusFieldKey;
	}
	
	/**
	 * 取得状态字段标识
	 * @return 状态字段标识
	 */
	public String getStatusFieldKey() {
		return this.statusFieldKey;
	}
	
	/**
	 * 设置状态字段的值(字符串)
	 * @param statusValue 字符串表示的状态字段的值
	 */
	public void setStatusValue(String statusValue) {
		this.statusValue = statusValue;
	}
	
	/**
	 * 取得状态字段的值(字符串)
	 * @return 字符中表示的状态字段的值
	 */
	public String getStatusValue() {
		return this.statusValue;
	}
	
	/**
	 * 设置迁移数据条件
	 * @param condition 迁移数据条件
	 */
	public void setCondition(String condition) {
		this.condition = condition;
	}
	
	/**
	 * 取得迁移数据条件
	 * @return 迁移数据条件
	 */
	public String getCondition() {
		return this.condition;
	}
	
	/**
	 * 设置资源路径
	 * @param resource 资源路径
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}
	
	/**
	 * 取得资源路径
	 * @return 资源路径
	 */
	public String getResource() {
		return this.resource;
	}
	
	/**
	 * 设置迁移元数据
	 * @param dataMigration 迁移元数据
	 */
	public void setDataMigration(MetaDataMigration dataMigration) {
		this.dataMigration = dataMigration;
	}
	
	/**
	 * 取得迁移元数据
	 * @return 迁移元数据
	 */
	public MetaDataMigration getDataMigration() {
		return this.dataMigration;
	}
	
	/**
	 * 设置工程引用
	 * @param project 工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}
	
	/**
	 * 取得工程引用
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}

	public String getExtend() {
		return extend;
	}

	public void setExtend(String extend) {
		this.extend = extend;
	}
}
