package com.bokesoft.yigo.meta.datamap.source;

public class FieldType {


	/** 字段域 */
	public static final int FIELD = 0;
	/** 字段域字符串表示 */
	public static final String STR_FIELD = "Field";

	/** 表达式 */
	public static final int FORMULA = 1;
	/** 表达式字符串表示 */
	public static final String STR_FORMULA = "Formula";

	/** 常量 */
	public static final int CONST = 2;
	/** 常量字符串表示 */
	public static final String STR_CONST = "Const";

	/** 加变化值 */
	public static final int OP_ADD_DELTA = 0;
	/** 加变化值字符串表示 */
	public static final String STR_OP_ADD_DELTA = "AddDelta";

	/** 直接赋值 */
	public static final int OP_ASSIGN = 1;
	/** 直接赋值字符串表示 */
	public static final String STR_OP_ASSIGN = "Assign";

	/** 空数据映射 */
	public static final int Pointer = -1;
	public static final String STR_Pointer = "Pointer";

	/** 普通数据映射 */
	public static final int EDGE_NORMAL = 0;
	/** 普通数据映射字符串表示 */
	public static final String STR_EDGE_NORMAL = "Normal";

	/** 关注字段映射 TODO 后续需要去掉*/
	public static final int EDGE_FOCUS = 1;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_FOCUS = "Focus";

	/** 关系KEY映射 */
	public static final int EDGE_MAP_KEY = 3;
	/** 关系KEY映射字符串表示 */
	public static final String STR_EDGE_MAP_KEY = "MapKey";

	
	public static final int EDGE_QUANTITYFOCUS_QUANTITY = 10;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_QUANTITY = "QUANTITYFOCUS_QUANTITY";
	
	public static final int EDGE_QUANTITYFOCUS_UNITID = 11;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_UNITID = "QUANTITYFOCUS_UNITID";
	
	public static final int EDGE_QUANTITYFOCUS_BASEQUANTITY = 12;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_BASEQUANTITY = "QUANTITYFOCUS_BASEQUANTITY";
	
	public static final int EDGE_QUANTITYFOCUS_BASEUNITID = 13;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_BASEUNITID = "QUANTITYFOCUS_BASEUNITID";
	
	public static final int EDGE_QUANTITYFOCUS_NUMERATOR = 14;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_NUMERATOR = "QUANTITYFOCUS_NUMERATOR";
	
	public static final int EDGE_QUANTITYFOCUS_DENOMINATOR = 15;
	/** 关注字段映射字符串表示 */
	public static final String STR_EDGE_QUANTITYFOCUS_DENOMINATOR = "QUANTITYFOCUS_DENOMINATOR";
	
	public static String formatTypeString(Integer type) {
		if(type == null) 
			return "";
		
		String s = null;
		switch (type) {
		case FIELD:
			s = STR_FIELD;
			break;
		case FORMULA:
			s = STR_FORMULA;
			break;
		case CONST:
			s = STR_CONST;
			break;
		}
		return s;
	}

	public static int parseType(String s) {
		int type = -1;
		if (STR_FIELD.equalsIgnoreCase(s)) {
			type = FIELD;
		} else if (STR_FORMULA.equalsIgnoreCase(s)) {
			type = FORMULA;
		} else if (STR_CONST.equalsIgnoreCase(s)) {
			type = CONST;
		}
		return type;
	}

	public static int parseOpSign(String s) {
		int sign = -1;
		if (STR_OP_ADD_DELTA.equalsIgnoreCase(s)) {
			sign = OP_ADD_DELTA;
		} else if (STR_OP_ASSIGN.equalsIgnoreCase(s)) {
			sign = OP_ASSIGN;
		}
		return sign;
	}

	public static String formatOpSignString(Integer sign) {
		if(sign == null)
			return "";
		
		String s = null;
		switch (sign) {
		case OP_ADD_DELTA:
			s = STR_OP_ADD_DELTA;
			break;
		case OP_ASSIGN:
			s = STR_OP_ASSIGN;
			break;
		}
		return s;
	}

	public static int parseEdgeType(String s) {
		int sign = -1;
		if (STR_EDGE_NORMAL.equalsIgnoreCase(s)) {
			sign = EDGE_NORMAL;
		} else if (STR_EDGE_FOCUS.equalsIgnoreCase(s)) {
			sign = EDGE_FOCUS;
		} else if (STR_EDGE_QUANTITYFOCUS_QUANTITY.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_QUANTITY;
		} else if (STR_EDGE_QUANTITYFOCUS_UNITID.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_UNITID;
		} else if (STR_EDGE_QUANTITYFOCUS_BASEQUANTITY.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_BASEQUANTITY;
		} else if (STR_EDGE_QUANTITYFOCUS_BASEUNITID.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_BASEUNITID;
		} else if (STR_EDGE_QUANTITYFOCUS_NUMERATOR.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_NUMERATOR;
		} else if (STR_EDGE_QUANTITYFOCUS_DENOMINATOR.equalsIgnoreCase(s)) {
			sign = EDGE_QUANTITYFOCUS_DENOMINATOR;
		} else if (STR_EDGE_MAP_KEY.equalsIgnoreCase(s)) {
			sign = EDGE_MAP_KEY;
		}
		return sign;
	}

	public static String formatEdgeTypeString(Integer edgeType) {
		if(edgeType == null)
			return "";
		
		String s = null;
		switch (edgeType) {
		case EDGE_NORMAL:
			s = STR_EDGE_NORMAL;
			break;
		case EDGE_FOCUS:
			s = STR_EDGE_FOCUS;
			break;
		case EDGE_QUANTITYFOCUS_QUANTITY:
			s = STR_EDGE_QUANTITYFOCUS_QUANTITY;
			break;
		case EDGE_QUANTITYFOCUS_UNITID:
			s = STR_EDGE_QUANTITYFOCUS_UNITID;
			break;
		case EDGE_QUANTITYFOCUS_BASEQUANTITY:
			s = STR_EDGE_QUANTITYFOCUS_BASEQUANTITY;
			break;
		case EDGE_QUANTITYFOCUS_BASEUNITID:
			s = STR_EDGE_QUANTITYFOCUS_BASEUNITID;
			break;
		case EDGE_QUANTITYFOCUS_NUMERATOR:
			s = STR_EDGE_QUANTITYFOCUS_NUMERATOR;
			break;
		case EDGE_QUANTITYFOCUS_DENOMINATOR:
			s = STR_EDGE_QUANTITYFOCUS_DENOMINATOR;
			break;
		case EDGE_MAP_KEY:
			s = STR_EDGE_MAP_KEY;
			break;
		}
		return s;
	}

}