package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 表单服务权限
 * 用户设置表单可以调用哪些后台服务
 * @author zhufw
 *
 */
public class MetaServiceRights extends KeyPairMetaObject {
	
	/** 服务标识 */
	private String key = "";
	/** 服务名称*/
	private String caption = "";
	/** 关联操作 */
	private String refOperation = "";
	
	/** 配置文件中对应节点的标签名称 */
	public static final String TAG_NAME = "ServiceRights";
	
	/**
	 * 设置服务标识
	 * @param key 服务标识
	 */
	public void setKey(String key){
		this.key = key;
	}
	
	/**
	 * 获取服务标识
	 * @return 服务标识
	 */
	public String getKey(){
		return this.key;
	}
	
	/**
	 * 设置服务名称
	 * @param caption 服务名称
	 */
	public void setCaption(String caption){
		this.caption = caption;
	}
	
	/**
	 * 获取服务名称
	 * @return 服务名称
	 */
	public String getCaption(){
		return this.caption;
	}
	
	/**
	 * 设置关联操作
	 * @param refOperation 关联操作
	 */
	public void setRefOperation(String refOperation){
		this.refOperation = refOperation;
	}
	
	/**
	 * 获取关联操作
	 * @return 关联操作
	 */
	public String getRefOperation(){
		return this.refOperation;
	}
	
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaServiceRights clone = new MetaServiceRights();
		clone.setKey(key);
		clone.setRefOperation(refOperation);
		clone.setCaption(caption);
		return clone;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaServiceRights();
	}

	@Override
	public String toString() {
		return "MetaServiceRights [key=" + key + ", caption=" + caption + ", refOperation=" + refOperation + "]";
	}

	
}
