package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.IPropertyMerger;

/**
 * MetaMacro定义宏公式的内容，一个宏公式包括名称、参数集合和宏公式的内容。
 * @author 王元和
 *
 */
public class MetaMacro extends KeyPairMetaObject implements IPropertyMerger<MetaMacro> {
	/** 宏公式的名称 */
	private String key = "";
	/** 宏公式的参数集合 */
	private String args = "";
	/** 处理后的参数集合*/
	private String[] argsList = null;
	/** 宏公式的内容 */
	private String content = "";

	
	@Override
	public String getKey() {
		return this.key;
	}
	
	/**
	 * 设置宏公式的名称
	 * @param key 宏公式名称
	 */
	public void setKey(String key) {
		this.key = key;
	}
	
	/**
	 * 设置宏公式参数集
	 * @param args 参数集
	 */
	public void setArgs(String args) {
		this.args = args;
		if ( args != null && !args.isEmpty() ) {
			argsList = args.split(",");
		} else {
			argsList = null;
		}
	}
	
	/**
	 * 取得宏公式参数集
	 * @return 宏公式参数集
	 */
	public String getArgs() {
		return this.args;
	}
	
	/**
	 * 取得宏公式参数集数组
	 * @return 宏公式参数集数组
	 */
	public String[] getArgsList() {
		return this.argsList;
	}
	
	/**
	 * 设置宏公式的内容
	 * @param content 宏公式的内容
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
	/**
	 * 取得宏公式的内容
	 * @return 宏公式的内容
	 */
	public String getContent() {
		return this.content;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Macro";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaMacro newObject = new MetaMacro();
		newObject.setKey(key);
		newObject.setArgs(args);
		newObject.setContent(content);
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMacro();
	}
	
	@Override
	public boolean needCheckExtend() {
		return true;
	}

	@Override
	public void merge(MetaMacro macro) {
		if( this.args == null ) {
			this.setArgs(macro.getArgs());
		}
		if( this.content == null ) {
			this.content = macro.getContent();
		}
	}

}
