package com.bokesoft.yigo.meta.common;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * MetaExtend定义二次开发的扩展类引用
 * @author 王元和
 *
 */
public class MetaExtend extends AbstractMetaObject {
	/** 类的全路径名 */
	private String className = "";
	/** 别名 */
	private String alias = "";
	
	public MetaExtend() {
		super();
	}
	
	/**
	 * 设置类名
	 * @param className 类名
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	
	/**
	 * 取得类名
	 * @return 类名
	 */
	public String getClassName() {
		return this.className;
	}
	
	/**
	 * 设置别名
	 * @param alias 别名
	 */
	public void setAlias(String alias) {
		this.alias = alias;
	}
	
	/**
	 * 取得别名
	 * @return 别名
	 */
	public String getAlias() {
		return this.alias;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub
		
	}

	public static final String TAG_NAME = "Extend";
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaExtend newObject = new MetaExtend();
		newObject.setClassName(className);
		newObject.setAlias(alias);
		
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExtend();
	}

}
