package com.bokesoft.yigo.meta.bpm.total;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataType;
import static com.bokesoft.yigo.common.def.SystemField.*;

import com.bokesoft.yigo.common.def.SystemDBField;
import com.bokesoft.yigo.common.def.SystemField;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaIndexCollection;
import com.bokesoft.yigo.meta.setting.MetaBPMMColumn;
import com.bokesoft.yigo.meta.setting.MetaBPMMTable;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;

public class BPMDataObjectCreater {

	// public static final String INSTANCE_ID_SYS_KEY = "InstanceID";

	public static final MetaDataObject getBPMDataObject(IMetaFactory fc) throws Throwable {
		MetaDataObject BPMDao = createMetaDataObject(SystemField.BPM_DATAOBJECT_KEY);
		MetaTable BPM_Instance = createTable(BPMDao,SystemField.BPM_INSTANCE_TABLE_KEY, SystemDBField.BPM_INSTANCE);
		BPM_Instance.setTableMode(TableMode.HEAD);
		addColumn(BPM_Instance, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Instance, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.PROCESSKEY_SYS_KEY, SystemDBField.PROCESSKEY, DataType.STRING, 255);
		addColumn(BPM_Instance, SystemField.WF_VERID_SYS_KEY, SystemDBField.WF_VERID, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.STARTTIME_SYS_KEY, SystemDBField.STARTTIME, DataType.DATETIME, 0);
		addColumn(BPM_Instance, SystemField.ENDTIME_SYS_KEY, SystemDBField.ENDTIME, DataType.DATETIME, 0);
		addColumn(BPM_Instance, SystemField.COSTTIME_SYS_KEY, SystemDBField.COSTTIME, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.INSTANCESTATE_SYS_KEY, SystemDBField.INSTANCESTATE, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.FORMKEY_SYS_KEY, SystemDBField.FORMKEY, DataType.STRING, 255);
		addColumn(BPM_Instance, SystemField.FORMNAME_SYS_KEY, SystemDBField.FORMNAME, DataType.STRING, 255);
		addColumn(BPM_Instance, SystemField.OBJECTKEY_SYS_KEY, SystemDBField.OBJECTKEY, DataType.STRING, 255);

		addColumn(BPM_Instance, SystemField.INSTANCEMODE_SYS_KEY, SystemDBField.INSTANCEMODE, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.PARENTINSTANCEID_SYS_KEY, SystemDBField.PARENTINSTANCEID, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.STEPIDSEED_SYS_KEY, SystemDBField.STEPIDSEED, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.TOKENIDSEED_SYS_KEY, SystemDBField.TOKENIDSEED, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.LOGSEED_SYS_KEY, SystemDBField.LOGSEED, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.LOGINDEXSEED_SYS_KEY, SystemDBField.LOGINDEXSEED, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.EVENTSEED_SYS_KEY, SystemDBField.EVENTSEED, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.STATEWORKITEMID_SYS_KEY, SystemDBField.STATEWORKITEMID, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.TRANSITTO_SYS_KEY, SystemDBField.TRANSITTO, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.TRANSWORKITEM_SYS_KEY, SystemDBField.TRANSWORKITEM, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.BPMSTATE_SYS_KEY, SystemDBField.BPMSTATE, DataType.INT, 0);
		addColumn(BPM_Instance, SystemField.BEGINOPERATORID_SYS_KEY, SystemDBField.BEGINOPERATORID, DataType.LONG, 0);
		addColumn(BPM_Instance, SystemField.DOCSTATE_SYS_KEY, SystemDBField.DOCSTATE, DataType.INT, 0);
		addIndex(BPM_Instance, OID_SYS_KEY, SystemDBField.OID);

		MetaTable BPM_Node = createTable(BPMDao, SystemField.BPM_NODE_TABLE_KEY, SystemDBField.BPM_NODE);
		addColumn(BPM_Node, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Node, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Node, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Node, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Node, SystemField.INLINEVERSION_SYS_KEY, SystemDBField.INLINEVERSION, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.NODETYPE_DICT_KEY, SystemDBField.NODETYPE, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.RESULT_SYS_KEY, SystemDBField.RESULT, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.SUBINSTANCEID_SYS_KEY, SystemDBField.SUBINSTANCEID, DataType.LONG, 0);
		addColumn(BPM_Node, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_Node, SystemField.BPMSTATE_SYS_KEY, SystemDBField.BPMSTATE, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.COUNTSEED_SYS_KEY, SystemDBField.COUNTSEED, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.INPUTDATAS_SYS_KEY, SystemDBField.INPUTDATAS, DataType.TEXT, 0);
		addColumn(BPM_Node, SystemField.MESSAGECOUNT_SYS_KEY, SystemDBField.MESSAGECOUNT, DataType.INT, 0);
		addColumn(BPM_Node, SystemField.INLINEPROCESSKEY_SYS_KEY, SystemDBField.INLINEPROCESSKEY, DataType.STRING, 255);
		addIndex(BPM_Node, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_NodeRB = createTable(BPMDao, SystemField.BPM_NODERB_TABLE_KEY, SystemDBField.BPM_NODERB);
		addColumn(BPM_NodeRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_NodeRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_NodeRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_NodeRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_NodeRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_NodeRB, SystemField.INLINEVERSION_SYS_KEY, SystemDBField.INLINEVERSION, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.NODETYPE_SYS_KEY, SystemDBField.NODETYPE, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.RESULT_SYS_KEY, SystemDBField.RESULT, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.SUBINSTANCEID_SYS_KEY, SystemDBField.SUBINSTANCEID, DataType.LONG, 0);
		addColumn(BPM_NodeRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_NodeRB, SystemField.BPMSTATE_SYS_KEY, SystemDBField.BPMSTATE, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.COUNTSEED_SYS_KEY, SystemDBField.COUNTSEED, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.INPUTDATAS_SYS_KEY, SystemDBField.INPUTDATAS, DataType.TEXT, 0);
		addColumn(BPM_NodeRB, SystemField.MESSAGECOUNT_SYS_KEY, SystemDBField.MESSAGECOUNT, DataType.INT, 0);
		addColumn(BPM_NodeRB, SystemField.INLINEPROCESSKEY_SYS_KEY, SystemDBField.INLINEPROCESSKEY, DataType.STRING, 255);
		addIndex(BPM_NodeRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_StepInfo = createTable(BPMDao, SystemField.BPM_STEPINFO_TABLE_KEY, SystemDBField.BPM_STEPINFO);
		addColumn(BPM_StepInfo, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_StepInfo, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_StepInfo, SystemField.STEPID_SYS_KEY, SystemDBField.STEPID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_StepInfo, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_StepInfo, SystemField.SOURCENODEID_SYS_KEY, SystemDBField.SOURCENODEID, DataType.INT, 0);
		addColumn(BPM_StepInfo, SystemField.TARGETNODEID_SYS_KEY, SystemDBField.TARGETNODEID, DataType.INT, 0);
		addColumn(BPM_StepInfo,	SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID , DataType.INT, 0);
		addColumn(BPM_StepInfo, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_StepInfo, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_StepInfoRB = createTable(BPMDao, SystemField.BPM_STEPINFORB_TABLE_KEY, SystemDBField.BPM_STEPINFORB);
		addColumn(BPM_StepInfoRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_StepInfoRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_StepInfoRB, SystemField.STEPID_SYS_KEY, SystemDBField.STEPID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_StepInfoRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_StepInfoRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_StepInfoRB, SystemField.SOURCENODEID_SYS_KEY, SystemDBField.SOURCENODEID, DataType.INT, 0);
		addColumn(BPM_StepInfoRB, SystemField.TARGETNODEID_SYS_KEY, SystemDBField.TARGETNODEID, DataType.INT, 0);
		addColumn(BPM_StepInfoRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_StepInfoRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_Token = createTable(BPMDao, SystemField.BPM_TOKEN_TABLE_KEY, SystemDBField.BPM_TOKEN);
		addColumn(BPM_Token, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Token, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Token, SystemField.TOKENID_SYS_KEY, SystemDBField.TOKENID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Token, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_Token, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_Token, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Token, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_Token, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_TokenRB = createTable(BPMDao, SystemField.BPM_TOKENRB_TABLE_KEY, SystemDBField.BPM_TOKENRB);
		addColumn(BPM_TokenRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TokenRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_TokenRB, SystemField.TOKENID_SYS_KEY, SystemDBField.TOKENID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TokenRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TokenRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_TokenRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_TokenRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_TokenRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		// 工作项相关数据
		MetaTable BPM_WorkitemInfo = createTable(BPMDao, SystemField.BPM_WORKITEMINFO_TABLE_KEY, SystemDBField.BPM_WORKITEMINFO);
		addColumn(BPM_WorkitemInfo, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemInfo, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfo, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemInfo, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.NODEKEY_SYS_KEY, SystemDBField.NODEKEY, DataType.STRING, 255);
		addColumn(BPM_WorkitemInfo, SystemField.FORMKEY_SYS_KEY, SystemDBField.FORMKEY, DataType.STRING, 255);
		addColumn(BPM_WorkitemInfo, SystemField.PARENTWORKITEMID_SYS_KEY, SystemDBField.PARENTWORKITEMID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfo, SystemField.PWORKITEMID4TRANSFER_SYS_KEY, SystemDBField.PWORKITEMID4TRANSFER, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfo, SystemField.TRANSITTO_SYS_KEY, SystemDBField.TRANSITTO, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.BACKSITEWORKITEMID_SYS_KEY, SystemDBField.BACKSITEWORKITEMID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfo, SystemField.COUNTID_SYS_KEY, SystemDBField.COUNTID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.BINDOID_SYS_KEY, SystemDBField.BINDOID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfo, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfo, SystemField.INLINEPARA_SYS_KEY, SystemDBField.INLINEPARA,DataType.STRING, 4000);
		addIndex(BPM_WorkitemInfo, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);
		addIndex(BPM_WorkitemInfo, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID);

		MetaTable BPM_WorkitemInfoRB = createTable(BPMDao, SystemField.BPM_WORKITEMINFORB_TABLE_KEY, SystemDBField.BPM_WORKITEMINFORB);
		addColumn(BPM_WorkitemInfoRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemInfoRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemInfoRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemInfoRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.NODEKEY_SYS_KEY, SystemDBField.NODEKEY, DataType.STRING, 255);
		addColumn(BPM_WorkitemInfoRB, SystemField.FORMKEY_SYS_KEY, SystemDBField.FORMKEY, DataType.STRING, 255);
		addColumn(BPM_WorkitemInfoRB, SystemField.PARENTWORKITEMID_SYS_KEY, SystemDBField.PARENTWORKITEMID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.PWORKITEMID4TRANSFER_SYS_KEY, SystemDBField.PWORKITEMID4TRANSFER, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.TRANSITTO_SYS_KEY, SystemDBField.TRANSITTO, DataType.INT, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.BACKSITEWORKITEMID_SYS_KEY, SystemDBField.BACKSITEWORKITEMID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.BINDOID_SYS_KEY, SystemDBField.BINDOID, DataType.LONG, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.COUNTID_SYS_KEY, SystemDBField.COUNTID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_WorkitemInfoRB, SystemField.INLINEPARA_SYS_KEY, SystemDBField.INLINEPARA,DataType.STRING, 4000);
		addIndex(BPM_WorkitemInfoRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_EventLog = createTable(BPMDao, SystemField.BPM_EVENTLOG_TABLE_KEY, SystemDBField.BPM_EVENTLOG);
		addColumn(BPM_EventLog, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_EventLog, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_EventLog, SystemField.LOGID_SYS_KEY, SystemDBField.LOGID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_EventLog, SystemField.EVENTTIME_SYS_KEY, SystemDBField.EVENTTIME, DataType.DATETIME, 0);
		addColumn(BPM_EventLog, SystemField.ACTIONTYPE_SYS_KEY, SystemDBField.ACTIONTYPE, DataType.INT, 0);
		addColumn(BPM_EventLog, SystemField.NAME_DICT_KEY, SystemDBField.NAME, DataType.STRING, 255);
		addColumn(BPM_EventLog, SystemField.SOPERATOR_SYS_KEY, SystemDBField.SOPERATOR, DataType.LONG, 0);
		addColumn(BPM_EventLog, SystemField.TOPERATOR_SYS_KEY, SystemDBField.TOPERATOR, DataType.LONG, 0);
		addColumn(BPM_EventLog, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 255);
		addIndex(BPM_EventLog, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_AuditRetLog = createTable(BPMDao, SystemField.BPM_AUDITRETLOG_TABLE_KEY, SystemDBField.BPM_AUDITRETLOG);
		addColumn(BPM_AuditRetLog, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_AuditRetLog, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_AuditRetLog, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_AuditRetLog, SystemField.USERID_SYS_KEY, SystemDBField.USERID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_AuditRetLog, SystemField.AUDITRESULT_SYS_KEY, SystemDBField.AUDITRESULT, DataType.INT, 0);
		addColumn(BPM_AuditRetLog, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 255);
		addColumn(BPM_AuditRetLog, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_AuditRetLog, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addIndex(BPM_AuditRetLog, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_TransitTo = createTable(BPMDao, SystemField.BPM_TRANSITTO_TABLE_KEY, SystemDBField.BPM_TRANSITTO);
		addColumn(BPM_TransitTo, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0);
		addColumn(BPM_TransitTo, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_TransitTo, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TransitTo, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_TransitTo, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_TransitTo, SystemField.TRANSITTOWORKITEM_SYS_KEY, SystemDBField.TRANSITTOWORKITEM, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TransitTo, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_TransitTo, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_TransitTo, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);
		
		MetaTable BPM_TransitToRB = createTable(BPMDao, SystemField.BPM_TRANSITTORB_TABLE_KEY, SystemDBField.BPM_TRANSITTORB);
		addColumn(BPM_TransitToRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0);
		addColumn(BPM_TransitToRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_TransitToRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TransitToRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_TransitToRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_TransitToRB, SystemField.TRANSITTOWORKITEM_SYS_KEY, SystemDBField.TRANSITTOWORKITEM, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TransitToRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TransitToRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_TransitToRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_Log = createTable(BPMDao, SystemField.BPM_LOG_TABLE_KEY, SystemDBField.BPM_LOG);
		addColumn(BPM_Log, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Log, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Log, SystemField.LOGID_SYS_KEY, SystemDBField.LOGID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Log, SystemField.LOGINDEX_SYS_KEY, SystemDBField.LOGINDEX, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_Log, SystemField.WORKITEMNAME_SYS_KEY, SystemDBField.WORKITEMNAME, DataType.STRING, 255);
		addColumn(BPM_Log, SystemField.WORKITEMSTATE_SYS_KEY, SystemDBField.WORKITEMSTATE, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addColumn(BPM_Log, SystemField.FINISHTIME_SYS_KEY, SystemDBField.FINISHTIME, DataType.DATETIME, 0);
		addColumn(BPM_Log, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0);
		addColumn(BPM_Log, SystemField.AUDITRESULT_SYS_KEY, SystemDBField.AUDITRESULT, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 4000);
		addColumn(BPM_Log, SystemField.RESULTINFO_SYS_KEY, SystemDBField.RESULTINFO, DataType.STRING, 255);
		addColumn(BPM_Log, SystemField.LAUNCHINFO_SYS_KEY, SystemDBField.LAUNCHINFO, DataType.STRING, 255);
		addColumn(BPM_Log, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Log, SystemField.PARENTWORKITEMID_SYS_KEY, SystemDBField.PARENTWORKITEMID, DataType.LONG, 0);
		addIndex(BPM_Log, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_LogRB = createTable(BPMDao, SystemField.BPM_LOGRB_TABLE_KEY, SystemDBField.BPM_LOGRB);
		addColumn(BPM_LogRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_LogRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_LogRB, SystemField.LOGID_SYS_KEY, SystemDBField.LOGID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_LogRB, SystemField.LOGINDEX_SYS_KEY, SystemDBField.LOGINDEX, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_LogRB, SystemField.WORKITEMNAME_SYS_KEY, SystemDBField.WORKITEMNAME, DataType.STRING, 255);
		addColumn(BPM_LogRB, SystemField.WORKITEMSTATE_SYS_KEY, SystemDBField.WORKITEMSTATE, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addColumn(BPM_LogRB, SystemField.FINISHTIME_SYS_KEY, SystemDBField.FINISHTIME, DataType.DATETIME, 0);
		addColumn(BPM_LogRB, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0);
		addColumn(BPM_LogRB, SystemField.AUDITRESULT_SYS_KEY, SystemDBField.AUDITRESULT, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 4000);
		addColumn(BPM_LogRB, SystemField.RESULTINFO_SYS_KEY, SystemDBField.RESULTINFO, DataType.STRING, 255);
		addColumn(BPM_LogRB, SystemField.LAUNCHINFO_SYS_KEY, SystemDBField.LAUNCHINFO, DataType.STRING, 255);
		addColumn(BPM_LogRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_LogRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_LogRB, SystemField.PARENTWORKITEMID_SYS_KEY, SystemDBField.PARENTWORKITEMID, DataType.LONG, 0);
		addIndex(BPM_LogRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_TimerEvent = createTable(BPMDao, SystemField.BPM_TIMEREVENT_TABLE_KEY, SystemDBField.BPM_TIMEREVENT);
		addColumn(BPM_TimerEvent, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEvent, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_TimerEvent, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEvent, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEvent, SystemField.EVENTTIME_SYS_KEY, SystemDBField.EVENTTIME, DataType.DATETIME, 0);
		addColumn(BPM_TimerEvent, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_TimerEvent, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_TimerEvent, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_TimerEventRB = createTable(BPMDao, SystemField.BPM_TIMEREVENTRB_TABLE_KEY, SystemDBField.BPM_TIMEREVENTRB);
		addColumn(BPM_TimerEventRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEventRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_TimerEventRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEventRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEventRB, SystemField.EVENTTIME_SYS_KEY, SystemDBField.EVENTTIME, DataType.DATETIME, 0);
		addColumn(BPM_TimerEventRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_TimerEventRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_TimerEventRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_FocusInstance = createTable(BPMDao, SystemField.BPM_FOCUSINSTANCE_TABLE_KEY, SystemDBField.BPM_FOCUSINSTANCE);
		addColumn(BPM_FocusInstance, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusInstance, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_FocusInstance, SystemField.FOCUSINSTANCEID_SYS_KEY, SystemDBField.FOCUSINSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusInstance, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_FocusInstance, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_FocusInstance, SystemField.INSTANCESYNCSTATE_SYS_KEY, SystemDBField.INSTANCESYNCSTATE, DataType.INT, 0);
		addColumn(BPM_FocusInstance, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_FocusInstance, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_FocusInstance, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_FocusInstanceRB = createTable(BPMDao, SystemField.BPM_FOCUSINSTANCERB_TABLE_KEY, SystemDBField.BPM_FOCUSINSTANCERB);
		addColumn(BPM_FocusInstanceRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusInstanceRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_FocusInstanceRB, SystemField.FOCUSINSTANCEID_SYS_KEY, SystemDBField.FOCUSINSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusInstanceRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_FocusInstanceRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_FocusInstanceRB, SystemField.INSTANCESYNCSTATE_SYS_KEY, SystemDBField.INSTANCESYNCSTATE, DataType.INT, 0);
		addColumn(BPM_FocusInstanceRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_FocusInstanceRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_FocusInstanceRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_FocusedInstance = createTable(BPMDao, SystemField.BPM_FOCUSEDINSTANCE_TABLE_KEY, SystemDBField.BPM_FOCUSEDINSTANCE);
		addColumn(BPM_FocusedInstance, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusedInstance, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_FocusedInstance, SystemField.FOCUSEDINSTANCEID_SYS_KEY, SystemDBField.FOCUSEDINSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusedInstance, SystemField.SYNCTRIGGERTYPE_SYS_KEY, SystemDBField.SYNCTRIGGERTYPE, DataType.INT, 0);
		addColumn(BPM_FocusedInstance, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_FocusedInstance, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_FocusedInstance, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_FocusedInstanceRB = createTable(BPMDao, SystemField.BPM_FOCUSEDINSTANCERB_TABLE_KEY, SystemDBField.BPM_FOCUSEDINSTANCERB);
		addColumn(BPM_FocusedInstanceRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusedInstanceRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_FocusedInstanceRB, SystemField.FOCUSEDINSTANCEID_SYS_KEY, SystemDBField.FOCUSEDINSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_FocusedInstanceRB, SystemField.SYNCTRIGGERTYPE_SYS_KEY, SystemDBField.SYNCTRIGGERTYPE, DataType.INT, 0);
		addColumn(BPM_FocusedInstanceRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_FocusedInstanceRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_FocusedInstanceRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_Transaction = createTable(BPMDao, SystemField.BPM_TRANSACTION_TABLE_KEY, SystemDBField.BPM_TRANSACTION);
		addColumn(BPM_Transaction, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Transaction, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Transaction, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Transaction, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		addColumn(BPM_Transaction, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0);
		addColumn(BPM_Transaction, SystemField.WORKITEMREVOKE_SYS_KEY, SystemDBField.WORKITEMREVOKE, DataType.INT, 0);
		addColumn(BPM_Transaction, SystemField.FIELDKEY_LOWER_SYS_KEY, SystemDBField.FIELDKEY_LOWER, DataType.STRING, 255);
		addColumn(BPM_Transaction, SystemField.FIELDVALUE_SYS_KEY, SystemDBField.FIELDVALUE, DataType.STRING, 255);
		addColumn(BPM_Transaction, SystemField.STATUSVALUE_SYS_KEY, SystemDBField.STATUSVALUE, DataType.INT, 0);
		addIndex(BPM_Transaction, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		// 代理授权
		MetaTable WF_Delegate = createTable(BPMDao, SystemField.WF_DELEGATE_TABLE_KEY, SystemDBField.WF_DELEGATE );
		addColumn(WF_Delegate, SystemField.DELEGATEID_SYS_KEY, SystemDBField.DELEGATEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_Delegate, SystemField.DELEGATETYPE_SYS_KEY, SystemDBField.DELEGATETYPE, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.SRCOPERATORID_SYS_KEY, SystemDBField.SRCOPERATORID, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.TGTOPERATORID_SYS_KEY, SystemDBField.TGTOPERATORID, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.CREATERID_SYS_KEY, SystemDBField.CREATERID, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.OBJECTTYPE_SYS_KEY, SystemDBField.OBJECTTYPE, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.OBJECTKEY_SYS_KEY, SystemDBField.OBJECTKEY, DataType.STRING, 255);
		addColumn(WF_Delegate, SystemField.NODEKEY_SYS_KEY, SystemDBField.NODEKEY, DataType.STRING, 255);
		addColumn(WF_Delegate, SystemField.STARTTIME_SYS_KEY, SystemDBField.STARTTIME, DataType.DATETIME, 0);
		addColumn(WF_Delegate, SystemField.ENDTIME_SYS_KEY, SystemDBField.ENDTIME, DataType.DATETIME, 0);
		addColumn(WF_Delegate, SystemField.ALWAYSVALID_SYS_KEY, SystemDBField.ALWAYSVALID, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.ENABLE_DICT_KEY, SystemDBField.ENABLE, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.AUTORETREAT_SYS_KEY, SystemDBField.AUTORETREAT, DataType.INT, 0);
		addColumn(WF_Delegate, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 255);
		addIndex(WF_Delegate, SystemField.TIME_INDEX_KEY, 
				SystemDBField.STARTTIME + ","
				+ SystemDBField.ALWAYSVALID + ","
				+ SystemDBField.ENDTIME );

		MetaTable BPM_Timer = createTable(BPMDao, SystemField.BPM_TIMER_TABLE_KEY, SystemDBField.BPM_TIMER);
		addColumn(BPM_Timer, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Timer, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Timer, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Timer, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Timer, SystemField.ITEMKEY_SYS_KEY, SystemDBField.ITEMKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_Timer, SystemField.TRIGGERTIME_SYS_KEY, SystemDBField.TRIGGERTIME, DataType.DATETIME, 0);
		addIndex(BPM_Timer, INSTANCE_ID_SYS_KEY, 
				SystemDBField.INSTANCEID + ","
				+ SystemDBField.INLINENODEID + ","
				+ SystemDBField.NODEID);

		MetaTable BPM_WorkitemTimer = createTable(BPMDao,SystemField.BPM_WORKITEMTIMER_TABLE_KEY,  SystemDBField.BPM_WORKITEMTIMER);
		addColumn(BPM_WorkitemTimer, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0);
		addColumn(BPM_WorkitemTimer, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_WorkitemTimer, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_WorkitemTimer, SystemField.ITEMKEY_SYS_KEY, SystemDBField.ITEMKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_WorkitemTimer, SystemField.TRIGGERTIME_SYS_KEY, SystemDBField.TRIGGERTIME, DataType.DATETIME, 0);
		addIndex(BPM_WorkitemTimer, SystemField.WORKITEMID_INDEX_KEY, SystemDBField.WORKITEMID);

		MetaTable BPM_StateRB = createTable(BPMDao, SystemField.BPM_STATERB_TABLE_KEY, SystemDBField.BPM_STATERB);
		addColumn(BPM_StateRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_StateRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_StateRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_StateRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_StateRB, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_StateRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_StateRB, SystemField.OPERATIONNODEID_SYS_KEY, SystemDBField.OPERATIONNODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_StateRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_StateRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_StateRB, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		MetaTable BPM_State = createTable(BPMDao, SystemField.BPM_STATE_TABLE_KEY, SystemDBField.BPM_STATE);
		addColumn(BPM_State, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_State, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_State, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_State, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(BPM_State, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_State, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_State, SystemField.OPERATIONNODEID_SYS_KEY, SystemDBField. OPERATIONNODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_State, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_State, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addIndex(BPM_State, INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID);

		// 迁移表
		MetaTable BPM_Migration = createTable(BPMDao, SystemField.BPM_MIGRATION_TABLE_KEY, SystemDBField.BPM_MIGRATION);
		initColumn(fc, BPM_Migration);

		MetaTable BPM_DirectTransition = createTable(BPMDao, SystemField.BPM_DIRECTTRANSITION_TABLE_KEY, SystemDBField.BPM_DIRECTTRANSITION);
		addColumn(BPM_DirectTransition, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransition, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_DirectTransition, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransition, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransition, SystemField.TGTNODEID_SYS_KEY, SystemDBField.TGTNODEID, DataType.INT, 0);
		addColumn(BPM_DirectTransition, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_DirectTransition, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);

		MetaTable BPM_DirectTransitionRB = createTable(BPMDao, SystemField.BPM_DIRECTTRANSITIONRB_TABLE_KEY, SystemDBField.BPM_DIRECTTRANSITIONRB);
		addColumn(BPM_DirectTransitionRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransitionRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_DirectTransitionRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransitionRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransitionRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_DirectTransitionRB, SystemField.TGTNODEID_SYS_KEY, SystemDBField.TGTNODEID, DataType.INT, 0);
		addColumn(BPM_DirectTransitionRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);

		MetaTable BPM_Attachment = createTable(BPMDao, SystemField.BPM_ATTACHMENTINFO_TABLE_KEY, SystemDBField.BPM_ATTACHMENTINFO);
		addColumn(BPM_Attachment, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Attachment, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Attachment, SystemField.ATTACHMENTKEY_SYS_KEY, SystemDBField.ATTACHMENTKEY, DataType.STRING, 64).setPrimaryKey(true);
		addColumn(BPM_Attachment, SystemField.ATTACHMENTINFO_SYS_KEY, SystemDBField.ATTACHMENTINFO, DataType.STRING, 255);
		addColumn(BPM_Attachment, SystemField.ATTACHMENTPARA_SYS_KEY, SystemDBField.ATTACHMENTPARA, DataType.STRING, 255);
		addColumn(BPM_Attachment, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_Attachment, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);

		MetaTable BPM_AttachmentRB = createTable(BPMDao, SystemField.BPM_ATTACHMENTINFORB_TABLE_KEY, SystemDBField.BPM_ATTACHMENTINFORB);
		addColumn(BPM_AttachmentRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_AttachmentRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_AttachmentRB, SystemField.ATTACHMENTKEY_SYS_KEY, SystemDBField.ATTACHMENTKEY, DataType.STRING, 64).setPrimaryKey(true);
		addColumn(BPM_AttachmentRB, SystemField.ATTACHMENTINFO_SYS_KEY, SystemDBField.ATTACHMENTINFO, DataType.STRING, 255);
		addColumn(BPM_AttachmentRB, SystemField.ATTACHMENTPARA_SYS_KEY, SystemDBField.ATTACHMENTPARA, DataType.STRING, 255);
		addColumn(BPM_AttachmentRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_AttachmentRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		
		MetaTable BPM_NodeParticipator = createTable(BPMDao, SystemField.BPM_NODEPARTICIPATOR_TABLE_KEY, SystemDBField.BPM_NODEPARTICIPATOR);
		addColumn(BPM_NodeParticipator, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipator, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_NodeParticipator, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipator, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipator, SystemField.NEXTOPERATORID_SYS_KEY, SystemDBField.NEXTOPERATORID, DataType.LONG, 0);
		addColumn(BPM_NodeParticipator, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_NodeParticipator, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_NodeParticipator, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_NodeParticipator, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		
		MetaTable BPM_NodeParticipatorRB = createTable(BPMDao, SystemField.BPM_NODEPARTICIPATORRB_TABLE_KEY, SystemDBField.BPM_NODEPARTICIPATORRB);
		addColumn(BPM_NodeParticipatorRB, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipatorRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_NodeParticipatorRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipatorRB, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_NodeParticipatorRB, SystemField.NEXTOPERATORID_SYS_KEY, SystemDBField.NEXTOPERATORID, DataType.LONG, 0);
		addColumn(BPM_NodeParticipatorRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(BPM_NodeParticipatorRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);;
		addColumn(BPM_NodeParticipatorRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(BPM_NodeParticipatorRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0);
		
		//引用单据集合表
		MetaTable BPM_RefDoc = createTable(BPMDao, SystemField.BPM_REFDOC_TABLE_KEY, SystemDBField.BPM_REFDOC);
		addColumn(BPM_RefDoc, SystemField.INSTANCE_ID_SYS_KEY, SystemDBField.INSTANCEID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_RefDoc, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_RefDoc, SystemField.REFKEY_SYS_KEY, SystemDBField.REFKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_RefDoc, SystemField.REFOID_SYS_KEY, SystemDBField.REFOID, DataType.LONG, 0);
		
		//流程热部署表
		MetaTable BPM_HotDeploy = createTable(BPMDao, SystemField.BPM_HOTDEPLOY_TABLE_KEY, SystemDBField.BPM_HOTDEPLOY);
		addColumn(BPM_HotDeploy, SystemField.FORMKEY_SYS_KEY, SystemDBField.FORMKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_HotDeploy, SystemField.HOTDEPLOYID_SYS_KEY, SystemDBField.HOTDEPLOYID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_HotDeploy, SystemField.DATAOBJECTKEY_SYS_KEY, SystemDBField.DATAOBJECTKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_HotDeploy, SystemField.PROCESSKEY_SYS_KEY, SystemDBField.PROCESSKEY, DataType.STRING, 255);
		addColumn(BPM_HotDeploy, SystemField.WF_VERID_SYS_KEY, SystemDBField.WF_VERID, DataType.INT, 0);
		addColumn(BPM_HotDeploy, SystemField.PROCESSMAPINFO_SYS_KEY, SystemDBField.PROCESSMAPINFO, DataType.STRING, 255);
		
		//流程配置表
		MetaTable BPM_Process = createTable(BPMDao, SystemField.BPM_PROCESS_TABLE_KEY, SystemDBField.BPM_PROCESS);
		addColumn(BPM_Process, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(BPM_Process, SystemField.PROCESSKEY_SYS_KEY, SystemDBField.PROCESSKEY, DataType.STRING, 255).setPrimaryKey(true);
		addColumn(BPM_Process, SystemField.WF_VERID_SYS_KEY, SystemDBField.WF_VERID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(BPM_Process, SystemField.CAPTION_SYS_KEY, SystemDBField.CAPTION, DataType.STRING, 255);
		addColumn(BPM_Process, SystemField.DEFINATION_SYS_KEY, SystemDBField.DEFINATION, DataType.TEXT, 0);
		addColumn(BPM_Process, SystemField.ALREADYDEPLOY_SYS_KEY, SystemDBField.ALREADYDEPLOY, DataType.INT, 0);

		BPMDao.doPostProcess(0, null);
		return BPMDao;
	}

	private static final void initColumn(IMetaFactory fc, MetaTable BPM_Migration) throws Throwable {
		addColumn(BPM_Migration, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(BPM_Migration, SystemField.SOID_SYS_KEY, SystemDBField.SOID, DataType.LONG, 0);
		addColumn(BPM_Migration, SystemField.VERID_SYS_KEY, SystemDBField.WF_VERID, DataType.LONG, 0);
		addColumn(BPM_Migration, SystemField.DVERID_SYS_KEY, SystemDBField.DVERID, DataType.LONG, 0);
		addColumn(BPM_Migration, SystemField.POID_SYS_KEY, SystemDBField.POID, DataType.LONG, 0);
		addColumn(BPM_Migration, SystemField.BPM_OID_SYS_KEY, SystemDBField.BOID, DataType.LONG, 0);

		MetaSetting setting = fc.getSetting();
		if (setting == null)
			return;

		MetaBPMSetting bs = setting.getBPMSetting();
		if (bs == null)
			return;

		MetaBPMMTable table = bs.getBPMMTable(fc);
		for (MetaBPMMColumn column : table) {
			MetaColumn c = new MetaColumn();
			c.setCaption(column.getCaption());
			c.setKey(column.getKey());
			c.setDataType(column.getDataType());
			c.setDBColumnName(column.getDBColumnName());
			c.setDefaultValue(column.getDefaultValue());
			c.setLength(column.getLength());
			c.setPrecision(column.getPrecision());
			c.setScale(column.getScale());
			BPM_Migration.add(c);
		}
	}

	public static final MetaDataObject getWorkitemDataObject() throws MetaException {
		MetaDataObject workitemDao = createMetaDataObject(SystemField.WORKITEM_DATAOBJECT_KEY);

		MetaTable WF_workitem = createTable(workitemDao, SystemField.WF_WORKITEM_TABLE_KEY, SystemDBField.WF_WORKITEM);
		WF_workitem.setTableMode(TableMode.HEAD);
		addColumn(WF_workitem, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_workitem, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(WF_workitem, SystemField.WORKITEMNAME_SYS_KEY, SystemDBField.WORKITEMNAME, DataType.STRING, 255);
		addColumn(WF_workitem, SystemField.WORKITEMSTATE_SYS_KEY, SystemDBField.WORKITEMSTATE, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addColumn(WF_workitem, SystemField.FINISHTIME_SYS_KEY, SystemDBField.FINISHTIME, DataType.DATETIME, 0);
		addColumn(WF_workitem, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0);
		addColumn(WF_workitem, SystemField.SRCOPERATORID_SYS_KEY, SystemDBField.SRCOPERATORID, DataType.LONG, 0);
		addColumn(WF_workitem, SystemField.TRANSFERTYPE_SYS_KEY, SystemDBField.TRANSFERTYPE, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.AUDITRESULT_SYS_KEY, SystemDBField.AUDITRESULT, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 4000);
		addColumn(WF_workitem, SystemField.RESULTINFO_SYS_KEY, SystemDBField.RESULTINFO, DataType.STRING, 255);
		addColumn(WF_workitem, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.NODEKEY_SYS_KEY, SystemDBField.NODEKEY, DataType.STRING, 255);
		addColumn(WF_workitem, SystemField.NODETYPE_SYS_KEY, SystemDBField.NODETYPE, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.TRANSITTO_SYS_KEY, SystemDBField.TRANSITTO, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.BACKSITEWORKITEMID_SYS_KEY, SystemDBField.BACKSITEWORKITEMID, DataType.LONG, 0);
		addColumn(WF_workitem, SystemField.LAUNCHINFO_SYS_KEY, SystemDBField.LAUNCHINFO, DataType.STRING, 255);
		addColumn(WF_workitem, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.LOGID_SYS_KEY, SystemDBField.LOGID, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.PARENTAUDITRESULT_SYS_KEY, SystemDBField.PARENTAUDITRESULT, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.ALREADYRETURN_SYS_KEY, SystemDBField.ALREADYRETURN, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.ALREADYREVOKE_SYS_KEY, SystemDBField.ALREADYREVOKE, DataType.INT, 0);
		addColumn(WF_workitem, SystemField.MARKSTATE_SYS_KEY, SystemDBField.MARKSTATE, DataType.INT, 0);

		MetaTable WF_workitemRB = createTable(workitemDao, SystemField.WF_WORKITEMRB_TABLE_KEY, SystemDBField.WF_WORKITEMRB );
		addColumn(WF_workitemRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_workitemRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(WF_workitemRB, SystemField.WORKITEMNAME_SYS_KEY, SystemDBField.WORKITEMNAME, DataType.STRING, 255);
		addColumn(WF_workitemRB, SystemField.WORKITEMSTATE_SYS_KEY, SystemDBField.WORKITEMSTATE, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addColumn(WF_workitemRB, SystemField.FINISHTIME_SYS_KEY, SystemDBField.FINISHTIME, DataType.DATETIME, 0);
		addColumn(WF_workitemRB, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0);
		addColumn(WF_workitemRB, SystemField.SRCOPERATORID_SYS_KEY, SystemDBField.SRCOPERATORID, DataType.LONG, 0);
		addColumn(WF_workitemRB, SystemField.TRANSFERTYPE_SYS_KEY, SystemDBField.TRANSFERTYPE, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.AUDITRESULT_SYS_KEY, SystemDBField.AUDITRESULT, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.USERINFO_SYS_KEY, SystemDBField.USERINFO, DataType.STRING, 4000);
		addColumn(WF_workitemRB, SystemField.RESULTINFO_SYS_KEY, SystemDBField.RESULTINFO, DataType.STRING, 255);
		addColumn(WF_workitemRB, SystemField.INLINENODEID_SYS_KEY, SystemDBField.INLINENODEID, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.NODEID_SYS_KEY, SystemDBField.NODEID, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.NODETYPE_SYS_KEY, SystemDBField.NODETYPE, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.TRANSITTO_SYS_KEY, SystemDBField.TRANSITTO, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.BACKSITEWORKITEMID_SYS_KEY, SystemDBField.BACKSITEWORKITEMID, DataType.LONG, 0);
		addColumn(WF_workitemRB, SystemField.LAUNCHINFO_SYS_KEY, SystemDBField.LAUNCHINFO, DataType.STRING, 255);
		addColumn(WF_workitemRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(WF_workitemRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.LOGID_SYS_KEY, SystemDBField.LOGID, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.PARENTAUDITRESULT_SYS_KEY, SystemDBField.PARENTAUDITRESULT, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.ALREADYRETURN_SYS_KEY, SystemDBField.ALREADYRETURN, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.ALREADYREVOKE_SYS_KEY, SystemDBField.ALREADYREVOKE, DataType.INT, 0);
		addColumn(WF_workitemRB, SystemField.MARKSTATE_SYS_KEY, SystemDBField.MARKSTATE, DataType.INT, 0);
		addIndex(WF_workitemRB, SystemField.WORKITEMID_INDEX_KEY, SystemDBField.WORKITEMID);

		/*
		 * 在参与者表中增加字段Visible
		 * 
		 * @author wbh
		 */
		MetaTable WF_ParticipatorRB = createTable(workitemDao, SystemField.WF_PARTICIPATORRB_TABLE_KEY, SystemDBField.WF_PARTICIPATORRB);
		addColumn(WF_ParticipatorRB, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_ParticipatorRB, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_ParticipatorRB, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(WF_ParticipatorRB, SystemField.SRCOPERATORID_SYS_KEY, SystemDBField.SRCOPERATORID, DataType.LONG, 0);
		addColumn(WF_ParticipatorRB, SystemField.DELEGATEID_SYS_KEY, SystemDBField.DELEGATEID, DataType.LONG, 0);
		addColumn(WF_ParticipatorRB, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0).setPrimaryKey(true);
		addColumn(WF_ParticipatorRB, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(WF_ParticipatorRB, SystemField.VISIBLE_SYS_KEY, SystemDBField.VISIBLE, DataType.INT, 0);
		addColumn(WF_ParticipatorRB, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addIndex(WF_ParticipatorRB, SystemField.WORKITEMID_INDEX_KEY, SystemDBField.WORKITEMID);

		MetaTable WF_Participator = createTable(workitemDao, SystemField.WF_PARTICIPATOR_TABLE_KEY, SystemDBField.WF_PARTICIPATOR);
		addColumn(WF_Participator, SystemField.WORKITEMID_SYS_KEY, SystemDBField.WORKITEMID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_Participator, SystemField.OPERATORID_SYS_KEY, SystemDBField.OPERATORID, DataType.LONG, 0).setPrimaryKey(true);
		addColumn(WF_Participator, SystemField.OID_SYS_KEY, SystemDBField.OID, DataType.LONG, 0);
		addColumn(WF_Participator, SystemField.SRCOPERATORID_SYS_KEY, SystemDBField.SRCOPERATORID, DataType.LONG, 0);
		addColumn(WF_Participator, SystemField.DELEGATEID_SYS_KEY, SystemDBField.DELEGATEID, DataType.LONG, 0);
		addColumn(WF_Participator, SystemField.TRANSACTIONID_SYS_KEY, SystemDBField.TRANSACTIONID, DataType.INT, 0);
		addColumn(WF_Participator, SystemField.ASSISTTRANSACTIONID_SYS_KEY, SystemDBField.ASSISTTRANSACTIONID, DataType.INT, 0);
		addColumn(WF_Participator, SystemField.VISIBLE_SYS_KEY, SystemDBField.VISIBLE, DataType.INT, 0);
		addColumn(WF_Participator, SystemField.CREATETIME_SYS_KEY, SystemDBField.CREATETIME, DataType.DATETIME, 0);
		addIndex(WF_Participator, SystemField.WORKITEMID_INDEX_KEY, SystemDBField.WORKITEMID);

		workitemDao.doPostProcess(0, null);
		return workitemDao;
	}
	
	

	private static MetaDataObject createMetaDataObject(String mainTableKey) {
		MetaDataObject dataObject = new MetaDataObject();
		dataObject.setAutoGen(true);
		dataObject.setKey(mainTableKey);
		dataObject.setPrimaryType(DataObjectPrimaryType.ENTITY);
		MetaTableCollection tableCollection = new MetaTableCollection();
		dataObject.setCaption("");
		dataObject.setMainTableKey(mainTableKey);
		dataObject.setTableCollection(tableCollection);
		return dataObject;
	}

	private static MetaTable createTable(MetaDataObject dataObject, String key, String dbTableName) {
		MetaTable table = new MetaTable();
		table.setKey(key);
		table.setCaption("");
		table.setDBTableName(dbTableName);
		table.setFilter(null);
		table.setSourceType(TableSourceType.DATAOBJECT);
		table.setTableMode(TableMode.DETAIL);
		return dataObject.getTableCollection().add(table);
	}

	private static MetaColumn addColumn(MetaTable table, String key, String dbColumnName, int dataType, int length) {
		MetaColumn column = new MetaColumn();
		column.setKey(key);
		column.setCaption("");
		column.setDefaultValue("");
		column.setDescription("");
		column.setDBColumnName(dbColumnName);
		column.setDataType(dataType);
		column.setLength(length);
		column.setAutoGen(true);
		table.add(column);
		return column;
	}

	private static MetaIndex addIndex(MetaTable table, String key, String columns) {
		MetaIndexCollection indexCollection = table.getIndexCollection();
		if (indexCollection == null) {
			indexCollection = new MetaIndexCollection();
			table.setIndexCollection(indexCollection);
		}

		MetaIndex index = new MetaIndex();
		indexCollection.add(index);
		index.setColumns(columns);
		index.setKey(table.getIndexPrefix4Create() + key);
		return index;
	}

}
