package com.bokesoft.yigo.meta.bpm.process.transition;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaExceptionFlow extends MetaTransition {

	public final static String TAG_NAME = "ExceptionFlow";

	private Integer exceptionType = -1;

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaExceptionFlow();
	}

	public Integer getExceptionType() {
		return exceptionType;
	}

	public void setExceptionType(Integer exceptionType) {
		this.exceptionType = exceptionType;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("exception-type", exceptionType);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.exceptionType = json.optInt("exception-type");
	}

}
