package com.bokesoft.yigo.meta.bpm.process.perm;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaPerm extends AbstractMetaObject {

	public static final String TAG_NAME = "Perm";

	/** 单据标识 */
	private String formKey = "";
	/** 不可见性权限 */
	private MetaVisiblePerm visiblePerm = null;
	/** 可用性权限 */
	private MetaEnablePerm enablePerm = null;
	/** 操作权限 */
	private MetaOptPerm optPerm = null;
	
	private MetaPermExternalLink permExternalLink = null;
	
	public MetaPerm() {
		super();
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		if (visiblePerm != null)
			list.add(visiblePerm);
		if (enablePerm != null)
			list.add(enablePerm);
		if (optPerm != null)
			list.add(optPerm);
		if (permExternalLink != null)
			list.add(permExternalLink);
	}

	public boolean hasDetail() {
		if (visiblePerm != null && visiblePerm.size() > 0)
			return true;
		if (enablePerm != null && enablePerm.size() > 0)
			return true;
		if (optPerm != null && optPerm.size() > 0)
			return true;
		return false;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	/**
	 * 设置单据标识
	 * 
	 * @param processKey
	 *            单据标识
	 */
	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}

	/**
	 * 取得单据标识
	 * 
	 * @return 单据标识
	 */
	public String getFormKey() {
		return formKey;
	}

	/**
	 * 设置可见性权限
	 * 
	 * @param visiblePerm
	 *            可见性权限
	 */
	public void setVisiblePerm(MetaVisiblePerm visiblePerm) {
		this.visiblePerm = visiblePerm;
	}

	/**
	 * 取得可见性权限
	 * 
	 * @return 可见性权限
	 */
	public MetaVisiblePerm getVisiblePerm() {
		return this.visiblePerm;
	}

	/**
	 * 设置可用性权限
	 * 
	 * @param enablePerm
	 *            可用性权限
	 */
	public void setEnablePerm(MetaEnablePerm enablePerm) {
		this.enablePerm = enablePerm;
	}

	/**
	 * 取得可用性权限
	 * 
	 * @return 可用性权限
	 */
	public MetaEnablePerm getEnablePerm() {
		return this.enablePerm;
	}

	/**
	 * 设置操作权限
	 * 
	 * @param optPerm
	 *            操作权限
	 */
	public void setOptPerm(MetaOptPerm optPerm) {
		this.optPerm = optPerm;
	}

	/**
	 * 取得操作权限
	 * 
	 * @return 操作权限
	 */
	public MetaOptPerm getOptPerm() {
		return this.optPerm;
	}
	
	public void setPermExternalLink(MetaPermExternalLink permExternalLink) {
		this.permExternalLink = permExternalLink;
	}
	
	public MetaPermExternalLink getPermExternalLink() {
		return permExternalLink;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject resultMetaObject = null;
		if (MetaVisiblePerm.TAG_NAME.equals(tagName)) {
			this.visiblePerm = new MetaVisiblePerm();
			resultMetaObject = this.visiblePerm;
		} else if (MetaEnablePerm.TAG_NAME.equals(tagName)) {
			this.enablePerm = new MetaEnablePerm();
			resultMetaObject = this.enablePerm;
		} else if (MetaOptPerm.TAG_NAME.equals(tagName)) {
			this.optPerm = new MetaOptPerm();
			resultMetaObject = this.optPerm;
		} else if (MetaPermExternalLink.TAG_NAME.equals(tagName)) {
			this.permExternalLink = new MetaPermExternalLink();
			resultMetaObject = this.permExternalLink;
			resultMetaObject.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaPerm newObject = new MetaPerm();
		newObject.setFormKey(formKey);
		newObject.setVisiblePerm(visiblePerm == null ? null : (MetaVisiblePerm) visiblePerm.clone());
		newObject.setEnablePerm(enablePerm == null ? null : (MetaEnablePerm) enablePerm.clone());
		newObject.setOptPerm(optPerm == null ? null : (MetaOptPerm) optPerm.clone());
		newObject.setPermExternalLink(permExternalLink == null ? null : (MetaPermExternalLink)permExternalLink.clone());
		return newObject;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaPerm();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		obj.put("tag-name", getTagName());
		obj.put("formKey", formKey);
		if(visiblePerm != null){
			obj.put("visiblePerm", visiblePerm.toJSON());
		}
		if(enablePerm != null){
			obj.put("enablePerm", enablePerm.toJSON());
		}
		if(optPerm != null){
			obj.put("optPerm", optPerm.toJSON());
		}
		if(permExternalLink != null){
			obj.put("permExternalLink", permExternalLink.toJSON());
		}
		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		formKey = json.optString("formKey");
		if(json.has("visiblePerm")){
			visiblePerm = new MetaVisiblePerm();
			visiblePerm.fromJSON(json.getJSONObject("visiblePerm"));
		}
		if(json.has("visiblePerm")){
			enablePerm = new MetaEnablePerm();
			enablePerm.fromJSON(json.getJSONObject("enablePerm"));
		}
		if(json.has("visiblePerm")){
			optPerm = new MetaOptPerm();
			optPerm.fromJSON(json.getJSONObject("optPerm"));
		}
		if(json.has("visiblePerm")){
			permExternalLink = new MetaPermExternalLink();
			permExternalLink.fromJSON(json.getJSONObject("permExternalLink"));
		}
	}

}
