package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.timer.MetaTimerTask;

public class MetaTimer extends MetaNode {

	public final static String TAG_NAME = "Timer";

	private MetaTimerTask timer = new MetaTimerTask();

	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(timer);
	}

	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node,
				tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaTimerTask.TAG_NAME)) {
			timer = new MetaTimerTask();
			child = timer;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.TIMER;
	}

	@Override
	public AbstractMetaObject clone() {
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaTimer();
	}

	public MetaTimerTask getTimer() {
		return timer;
	}
	
	public void setTimer(MetaTimerTask timer){
		this.timer = timer;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		if ( timer != null ) {
			obj.put("timer", timer.toJSON());
		}
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		if ( json.has("timer") ) {
			timer = new MetaTimerTask();
			timer.fromJSON(json.getJSONObject("timer"));
		}
	}

}