package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.message.MetaMessageCollection;

public class MetaMessageSend extends MetaNode {
	public static final String TAG_NAME = "MessageSend";
	private Integer receiverID = -1;
	
	private MetaMessageCollection messageCollection = null;

	public MetaMessageCollection getMessageCollection() {
		return messageCollection;
	}

	public void setMessageCollection(MetaMessageCollection messageCollection) {
		this.messageCollection = messageCollection;
	}

	public Integer getReceiverID() {
		return receiverID;
	}

	public void setReceiverID(Integer receiverID) {
		this.receiverID = receiverID;
	}

	@Override
	public int getNodeType() {
		return NodeType.MESSAGE_SEND;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaMessageSend();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaMessageSend obj = (MetaMessageSend) super.clone();
		obj.receiverID = receiverID;
		obj.messageCollection = messageCollection == null ? null : (MetaMessageCollection)messageCollection.clone();
		return obj;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
		if (MetaMessageCollection.TAG_NAME.equals(tagName)) {
			messageCollection = new MetaMessageCollection();
			child = messageCollection;
		}
		return child;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		addAll(list, new Object[] {messageCollection});
	}

}
