package com.bokesoft.yigo.meta.bpm.process.node;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;

public class MetaEvent extends MetaNode {

	public final static String TAG_NAME = "Event";

	private String eventTrigger = "";

	public String getEventTrigger() {
		return eventTrigger;
	}

	public void setEventTrigger(String eventTrigger) {
		this.eventTrigger = eventTrigger;
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.EVENT;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaEvent newEvent = (MetaEvent) super.clone();
		newEvent.setEventTrigger(eventTrigger);
		return newEvent;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaEvent();
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("event-trigger", eventTrigger);
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.eventTrigger = json.optString("event-trigger");
	}

}