package com.bokesoft.yigo.meta.bpm.process.node;

import java.util.LinkedList;

import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBillDataMapInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.type.SyncTriggerType;

/**
 * 数据映射节点
 * 
 * @author 刘翔翔
 *
 */
public class MetaDataMap extends MetaUserTask {

	public final static String TAG_NAME = "DataMap";

	/** 是否为中间层数据映射 */
	private Boolean midDataMap = false;

	/** 同步触发时机 */
	private Integer syncTriggerType = SyncTriggerType.NO_OPT;

	/** 自定义数据映射完结条件 */
	private String dataMapCondition = "";

	/** 数据映射 */
	private MetaBillDataMapInfoCollection billDataMapInfoCollection = new MetaBillDataMapInfoCollection();

	public void getChildMetaObjects(LinkedList<Object> list) {
		super.getChildMetaObjects(list);
		list.add(billDataMapInfoCollection);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.DATAMAP;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		AbstractMetaObject child = super.createChildMetaObject(env, doc, node,
				tagName, flag, runType);
		if (child != null)
			return child;
		if (tagName.equalsIgnoreCase(MetaBillDataMapInfoCollection.TAG_NAME)) {
			billDataMapInfoCollection = new MetaBillDataMapInfoCollection();
			child = billDataMapInfoCollection;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}

		return child;
	}

	public Boolean getMidDataMap() {
		return midDataMap;
	}

	public void setMidDataMap(Boolean midDataMap) {
		this.midDataMap = midDataMap;
	}

	public Integer getSyncTriggerType() {
		return syncTriggerType;
	}

	public void setSyncTriggerType(Integer syncTriggerType) {
		this.syncTriggerType = syncTriggerType;
	}

	public String getDataMapCondition() {
		return dataMapCondition;
	}

	public void setDataMapCondition(String dataMapCondition) {
		this.dataMapCondition = dataMapCondition;
	}

	public MetaBillDataMapInfoCollection getBillDataMapInfoCollection() {
		return billDataMapInfoCollection;
	}
	
	public void setBillDataMapInfoCollection(MetaBillDataMapInfoCollection billDataMapInfoCollection) {
		this.billDataMapInfoCollection = billDataMapInfoCollection;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDataMap();
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDataMap newDataMap = (MetaDataMap) super.clone();
		newDataMap.setMidDataMap(midDataMap);
		newDataMap.setSyncTriggerType(syncTriggerType);
		newDataMap.setDataMapCondition(dataMapCondition);
		newDataMap.setBillDataMapInfoCollection(billDataMapInfoCollection == null ? null : (MetaBillDataMapInfoCollection) billDataMapInfoCollection.clone());
		return newDataMap;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = super.toJSON();
		obj.put("mid-data-map", midDataMap);
		obj.put("sync-trigger-type", syncTriggerType);
		obj.put("data-map-condition", dataMapCondition);
		if ( billDataMapInfoCollection != null ) {
			obj.put("bill-data-map-infos", billDataMapInfoCollection.toJSON());
		}
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		super.fromJSON(json);
		this.midDataMap = json.optBoolean("mid-data-map");
		this.syncTriggerType = json.optInt("sync-trigger-type");
		this.dataMapCondition = json.optString("data-map-condition");
		if ( json.has("bill-data-map-infos") ) {
			billDataMapInfoCollection = new MetaBillDataMapInfoCollection();
			billDataMapInfoCollection.fromJSON(json.getJSONObject("bill-data-map-infos"));
		}
	}
}
