package com.bokesoft.yigo.meta.bpm.process.message;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaNodeMessage extends AbstractMetaObject {

	public static final String TAG_NAME = "NodeMessage";
	
	/** 消息发送设置 */
	private MetaProducer producer = new MetaProducer();
	
	/** 消息接收设置 */
	private MetaConsumer consumer = new MetaConsumer();
	
	public MetaProducer getProducer() {
		return producer;
	}
	
	public void setProducer(MetaProducer producer) {
		this.producer = producer;
	}
	
	public MetaConsumer getConsumer() {
		return consumer;
	}
	
	public void setConsumer(MetaConsumer consumer) {
		this.consumer = consumer;
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaNodeMessage obj = (MetaNodeMessage) newInstance();
		obj.setProducer(producer == null ? null : (MetaProducer) producer.clone());
		obj.setConsumer(consumer == null ? null : (MetaConsumer) consumer.clone());
		return obj;
	}
	
	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {
		AbstractMetaObject child = null;
		if (tagName.equalsIgnoreCase(MetaProducer.TAG_NAME)) {
			producer = new MetaProducer();
			child = producer;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaConsumer.TAG_NAME)) {
			consumer = new MetaConsumer();
			child = consumer;
			child.preProcessMetaObject(env, doc, node, flag, runType);
		}
		return child;
	}
	
	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(producer);
		list.add(consumer);
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaNodeMessage();
	}
	
}
