package com.bokesoft.yigo.meta.bpm.process.attribute.participator;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.bpm.AbstractBPMNoKeyCollection;

public class MetaSourceParaCollection extends AbstractBPMNoKeyCollection<MetaSourcePara> {

	public final static String TAG_NAME = "SourceParaCollection";
	
	@Override
	protected MetaSourcePara createChildMetaElement(String tagName) {
		MetaSourcePara child = null;
		if (tagName.equalsIgnoreCase(MetaSourcePara.TAG_NAME)) {
			child = new MetaSourcePara();
		}
		return child;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}
	
	@Override
	public AbstractMetaObject newInstance() {
		return new MetaSourceParaCollection();
	}
	
	@Override
	public JSONObject toJSON() throws SerializationException {
		JSONObject obj = new JSONObject();
		JSONArray sourceParaArray = new JSONArray();
		Iterator<MetaSourcePara> it = this.elementArray.iterator();
		MetaSourcePara metaSourcePara = null;
		while (it.hasNext()) {
			metaSourcePara = it.next();
			sourceParaArray.put(metaSourcePara.toJSON());
		}
		obj.put("sourceparaitems", sourceParaArray);

		return obj;
	}
	
	@Override
	public void fromJSON(JSONObject json) throws SerializationException {
		if (json.has("sourceparaitems")) {
			JSONArray sourceParaArray = json.getJSONArray("sourceparaitems");
			for (int i = 0, size = sourceParaArray.length(); i < size; ++i) {
				JSONObject sourceParaObj = sourceParaArray.getJSONObject(i);
				MetaSourcePara metaSourcePara = new MetaSourcePara();
				metaSourcePara.fromJSON(sourceParaObj);
				this.add(metaSourcePara);
			}
		}
	}
}
