package com.bokesoft.yigo.meta.bpm.process.attribute;

import java.util.Iterator;
import java.util.Map.Entry;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.AbstractBPMCollection;

public class MetaBPMInfoCollection extends AbstractBPMCollection<MetaBPMInfo> {

	public final static String TAG_NAME = "BPMInfoCollection";

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaBPMInfo child = null;
		if (tagName.equalsIgnoreCase(MetaBPMInfo.TAG_NAME)) {
			child = new MetaBPMInfo();
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(child);
		}
		return child;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaBPMInfoCollection();
	}

	@Override
	protected MetaBPMInfo createChildMetaElement(String tagName) {
		MetaBPMInfo child = null;
		if (tagName.equalsIgnoreCase(MetaBPMInfo.TAG_NAME))
			child = new MetaBPMInfo();
		return child;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		JSONArray bpmInfoArray = new JSONArray();
		Iterator<Entry<String, MetaBPMInfo>> it = this.elementMap.entrySet().iterator();
		Entry<String, MetaBPMInfo> entry = null;
		MetaBPMInfo bpmInfo = null;
		while ( it.hasNext() ) {
			entry = it.next();
			bpmInfo = entry.getValue();
			bpmInfoArray.put(bpmInfo.toJSON());
		}
		obj.put("items", bpmInfoArray);
		
		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		if ( json.has("items") ) {
			JSONArray bpmInfoArray = json.getJSONArray("items");
			for ( int i = 0, size = bpmInfoArray.length(); i<size; ++i ) {
				JSONObject bpmInfoObj = bpmInfoArray.getJSONObject(i);
				MetaBPMInfo bpmInfo = new MetaBPMInfo();
				bpmInfo.fromJSON(bpmInfoObj);
				this.add(bpmInfo);
			}
		}
	}

}
