package com.bokesoft.yigo.meta.bpm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Queue;
import java.util.TreeMap;
import java.util.TreeSet;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yigo.common.def.BPMLockType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.GenericKeyCollection;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMTable;
import com.bokesoft.yigo.meta.bpm.process.attachment.MetaAttachmentCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaAssistanceCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaBPMInfoCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaOperationCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.participator.MetaParticipatorCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.processadministrator.MetaAdministratorCollection;
import com.bokesoft.yigo.meta.bpm.process.event.MetaEventCollection;
import com.bokesoft.yigo.meta.bpm.process.expand.MetaExpand;
import com.bokesoft.yigo.meta.bpm.process.multipleform.MetaRefFormCollection;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAnchor;
import com.bokesoft.yigo.meta.bpm.process.node.MetaAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBegin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaBranchEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaComplexJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaCountersign;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDataMap;
import com.bokesoft.yigo.meta.bpm.process.node.MetaDecision;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEnd;
import com.bokesoft.yigo.meta.bpm.process.node.MetaEvent;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaExclusiveJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaFork;
import com.bokesoft.yigo.meta.bpm.process.node.MetaGateWay;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaJoin;
import com.bokesoft.yigo.meta.bpm.process.node.MetaManualTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageReceive;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMessageSend;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiAudit;
import com.bokesoft.yigo.meta.bpm.process.node.MetaMultiUserTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.node.MetaServiceTask;
import com.bokesoft.yigo.meta.bpm.process.node.MetaState;
import com.bokesoft.yigo.meta.bpm.process.node.MetaStateAction;
import com.bokesoft.yigo.meta.bpm.process.node.MetaSubProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaTimer;
import com.bokesoft.yigo.meta.bpm.process.node.MetaUserTask;
import com.bokesoft.yigo.meta.bpm.process.node.NodeType;
import com.bokesoft.yigo.meta.bpm.process.perm.MetaPermCollection;
import com.bokesoft.yigo.meta.bpm.process.perm.extend.MetaInitiatorPermCollection;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;

/**
 * 流程定义配置对象
 * 
 * @author 刘翔翔
 *
 */
public class MetaProcess extends GenericKeyCollection<MetaNode> {

	/** 根元素对应的标签名 */
	public final static String TAG_NAME = "Process";

	/** 流程的KEY */
	private String key = "";

	/** 流程的名称 */
	private String caption = "";

	/** 节点ID计数器 */
	private Integer idSeed = 0;

	/** 流程的版本 */
	private Integer version = 1;

	/** 用于权限设置的单据（作为模板） */
	private String formKey = "";
	
	/** 流程打开的表单的反向模板定义*/
	private String templateKey = "";
	
	private Boolean ignoreFormState = null;
	
	/** 是否在单据载入数据的过程中查询撤销工作项的信息 */
	private Boolean queryRetreatWorkitem = true;
	
	/** 关闭实例触发器 */
	private String killInstanceTrigger = "";
	
	/** 二次开发接口*/
	private MetaExpand expand = null;
	
	/** 驳回后是否锁定工作项，默认值为false*/
	private Integer lockWorkitem = BPMLockType.FALSE;
	
	/** 工作项创建事件*/
	private String workitemCreateTrigger ="";
	
	/** 流程管理者停止干预的标记*/
	private String forbidOperateMark = "";

	/** 流程的泳道设置 */
	private MetaSwimlineCollection swimlineCollection = new MetaSwimlineCollection();

	/** 流程的信息 */
	private MetaBPMInfoCollection BPMInfoCollection = new MetaBPMInfoCollection();

	/** 迁移表设置 */
	private MetaDMTable dataMigrationTable = new MetaDMTable();

	/** 权限设置 */
	private MetaPermCollection permCollection = new MetaPermCollection();
	
	/** 发起人权限*/
	private MetaInitiatorPermCollection initiatorPermCollection = new MetaInitiatorPermCollection();

	/** 附件设置 */
	private MetaAttachmentCollection attachmentCollection = new MetaAttachmentCollection();
	
	/** 流程管理员操作的集合 */
	protected MetaOperationCollection administratorOperationCollection = new MetaOperationCollection();
	
	/** 全局参与者的集合 */
	private MetaParticipatorCollection globalptorCollection = null;
	
	/** 全局管理者集合*/
	private MetaAdministratorCollection administratorCollection = null;
	
	/** 操作触发事件集合*/
	private MetaEventCollection eventCollection = null;
	/**流程引用表单定义集合 */
	private MetaRefFormCollection refFormCollection = null;
	// 以下内容是预处理中后添加的数据不做保存
	/** 以ID为KEY的节点Map */
	private TreeMap<Integer, MetaNode> nodeMapByID = null;
	/** 辅助节点和主节点的关联关系 (ID) */
	private TreeMap<Integer, Integer> assistanceMapByID = null;
	/** 辅助节点和主节点的关联关系 (KEY) */
	private HashMap<String, String> assistanceMapByKey = null;
	/** 辅助节点集合，由于ID是全局唯一的，所以可以构造辅助节点的全局映射*/
	private TreeMap<Integer, MetaNode> assistanceNodeMap = null;
	
	/** 节点的直接前驱节点集合*/
	private HashMap<Integer,ArrayList<Integer>>preNodesMap = null;
	
	/** 当前流程结束后是否允许撤销工作项, 动态属性, 通过结束节点的是否可撤销属性来判定 */
	private boolean allowRevokeAfterEnd = true;
	
	public MetaExpand getExpand() {
		return expand;
	}
	
	public void setExpand(MetaExpand expand) {
		this.expand = expand;
	}

	public MetaSwimlineCollection getSwimlineCollection() {
		return swimlineCollection;
	}

	public void setSwimlineCollection(MetaSwimlineCollection swimlineCollection) {
		this.swimlineCollection = swimlineCollection;
	}

	public MetaBPMInfoCollection getBPMInfoCollection() {
		return BPMInfoCollection;
	}

	public void setBPMInfoCollection(MetaBPMInfoCollection BPMInfoCollection) {
		this.BPMInfoCollection = BPMInfoCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		list.add(expand);
		list.add(swimlineCollection);
		list.add(BPMInfoCollection);
		list.add(dataMigrationTable);
		list.add(permCollection);
		list.add(attachmentCollection);
		list.add(globalptorCollection);
		list.add(eventCollection);
		list.add(refFormCollection);
		list.add(initiatorPermCollection);
		list.add(administratorCollection);
		list.add(administratorOperationCollection);
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	private MetaNode createNode(String tagName) {
		MetaNode child = null;
		if (tagName.equalsIgnoreCase(MetaAudit.TAG_NAME)) {
			child = new MetaAudit();
		} else if (tagName.equalsIgnoreCase(MetaBegin.TAG_NAME)) {
			child = new MetaBegin();
		} else if (tagName.equalsIgnoreCase(MetaCountersign.TAG_NAME)) {
			child = new MetaCountersign();
		} else if (tagName.equalsIgnoreCase(MetaDecision.TAG_NAME)) {
			child = new MetaDecision();
		} else if (tagName.equalsIgnoreCase(MetaEnd.TAG_NAME)) {
			child = new MetaEnd();
		} else if (tagName.equalsIgnoreCase(MetaEvent.TAG_NAME)) {
			child = new MetaEvent();
		} else if (tagName.equalsIgnoreCase(MetaFork.TAG_NAME)) {
			child = new MetaFork();
		} else if (tagName.equalsIgnoreCase(MetaJoin.TAG_NAME)) {
			child = new MetaJoin();
		} else if (tagName.equalsIgnoreCase(MetaState.TAG_NAME)) {
			child = new MetaState();
		} else if (tagName.equalsIgnoreCase(MetaSubProcess.TAG_NAME)) {
			child = new MetaSubProcess();
		} else if (tagName.equalsIgnoreCase(MetaUserTask.TAG_NAME)) {
			child = new MetaUserTask();
		} else if (tagName.equalsIgnoreCase(MetaTimer.TAG_NAME)) {
			child = new MetaTimer();
		} else if (tagName.equalsIgnoreCase(MetaInline.TAG_NAME)) {
			child = new MetaInline();
		} else if (tagName.equalsIgnoreCase(MetaDataMap.TAG_NAME)) {
			child = new MetaDataMap();
		} else if (tagName.equalsIgnoreCase(MetaComplexJoin.TAG_NAME)) {
			child = new MetaComplexJoin();
		} else if (tagName.equalsIgnoreCase(MetaExclusiveFork.TAG_NAME)) {
			child = new MetaExclusiveFork();
		} else if (tagName.equalsIgnoreCase(MetaManualTask.TAG_NAME)) {
			child = new MetaManualTask();
		} else if (tagName.equalsIgnoreCase(MetaServiceTask.TAG_NAME)) {
			child = new MetaServiceTask();
		} else if (tagName.equalsIgnoreCase(MetaBranchEnd.TAG_NAME)) {
			child = new MetaBranchEnd();
		} else if (tagName.equalsIgnoreCase(MetaStateAction.TAG_NAME)) {
			child = new MetaStateAction();
		} else if (tagName.equalsIgnoreCase(MetaMultiUserTask.TAG_NAME)) {
			child = new MetaMultiUserTask();
		} else if (tagName.equalsIgnoreCase(MetaMultiAudit.TAG_NAME)) {
			child = new MetaMultiAudit();
		} else if (tagName.equalsIgnoreCase(MetaGateWay.TAG_NAME)) {
			child = new MetaGateWay();
		} else if (tagName.equalsIgnoreCase(MetaMessageSend.TAG_NAME)) {
			child = new MetaMessageSend();
		} else if (tagName.equalsIgnoreCase(MetaMessageReceive.TAG_NAME)) {
			child = new MetaMessageReceive();
		} else if (tagName.equalsIgnoreCase(MetaExclusiveJoin.TAG_NAME)) {
			child = new MetaExclusiveJoin();
		} else if (tagName.equalsIgnoreCase(MetaAnchor.TAG_NAME)){
			child = new MetaAnchor();
		}
		return child;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
		MetaNode child = createNode(tagName);

		if (child != null) {
			child.preProcessMetaObject(env, doc, node, flag, runType);
			this.add(child);
			return child;
		}

		AbstractMetaObject amo = null;

		if (tagName.equalsIgnoreCase(MetaSwimlineCollection.TAG_NAME)) {
			swimlineCollection = new MetaSwimlineCollection();
			amo = swimlineCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaBPMInfoCollection.TAG_NAME)) {
			BPMInfoCollection = new MetaBPMInfoCollection();
			amo = BPMInfoCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaDMTable.TAG_NAME)) {
			dataMigrationTable = new MetaDMTable();
			amo = dataMigrationTable;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaPermCollection.TAG_NAME)) {
			permCollection = new MetaPermCollection();
			amo = permCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaAttachmentCollection.TAG)) {
			attachmentCollection = new MetaAttachmentCollection();
			amo = attachmentCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaParticipatorCollection.TAG_NAME)) {
			globalptorCollection = new MetaParticipatorCollection();
			amo = globalptorCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaExpand.TAG_NAME)) {
			expand = new MetaExpand();
			amo = expand;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaEventCollection.TAG_NAME)) {
			eventCollection = new MetaEventCollection();
			amo = eventCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaRefFormCollection.TAG_NAME)) {
			refFormCollection = new MetaRefFormCollection();
			amo = refFormCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaInitiatorPermCollection.TAG_NAME)) {
			initiatorPermCollection = new MetaInitiatorPermCollection();
			amo = initiatorPermCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaAdministratorCollection.TAG_NAME)) {
			administratorCollection = new MetaAdministratorCollection();
			amo = administratorCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		} else if (tagName.equalsIgnoreCase(MetaOperationCollection.TAG_NAME)) {
			administratorOperationCollection = new MetaOperationCollection();
			amo = administratorOperationCollection;
			amo.preProcessMetaObject(env, doc, node, flag, runType);
		}

		return amo;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaProcess();
	}

	public Integer getVersion() {
		return version;
	}

	public Integer getIdSeed() {
		return idSeed;
	}

	public void setIdSeed(Integer idSeed) {
		this.idSeed = idSeed;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public String getFormKey() {
		return formKey;
	}

	public void setFormKey(String formKey) {
		this.formKey = formKey;
	}
	
	public String getTemplateKey() {
		return templateKey;
	}
	
	public void setTemplateKey(String template) {
		this.templateKey = template;
	}
	
	public Boolean getIgnoreFormState() {
		return ignoreFormState;
	}
	
	public void setIgnoreFormState(Boolean ignoreFormState) {
		this.ignoreFormState = ignoreFormState;
	}
	
	public Boolean getQueryRetreatWorkitem(){
		return this.queryRetreatWorkitem;
	}
	
	public void setQueryRetreatWorkitem(Boolean queryRetreatWorkitem){
		this.queryRetreatWorkitem = queryRetreatWorkitem;
	}
	
	public Integer getLockWorkitem() {
		return lockWorkitem;
	}

	public void setLockWorkitem(Integer lockWorkitem) {
		this.lockWorkitem = lockWorkitem;
	}

	public String getKillInstanceTrigger() {
		return killInstanceTrigger;
	}

	public void setKillInstanceTrigger(String killInstanceTrigger) {
		this.killInstanceTrigger = killInstanceTrigger;
	}
	
	public MetaNode getNodeByID(int nodeID) {
		MetaNode node = nodeMapByID.get(nodeID);
		if (node != null)
			return node;

		if (assistanceNodeMap != null) {
			return assistanceNodeMap.get(nodeID);
		}
		return null;
	}

	public MetaDMTable getDataMigrationTable() {
		return dataMigrationTable;
	}

	public void setDataMigrationTable(MetaDMTable dataMigrationTable) {
		this.dataMigrationTable = dataMigrationTable;
	}

	public MetaPermCollection getPermCollection() {
		return permCollection;
	}

	public void setPermCollection(MetaPermCollection permCollection) {
		this.permCollection = permCollection;
	}
	
	public void setInitiatorPermCollection(MetaInitiatorPermCollection initiatorPermCollection) {
		this.initiatorPermCollection = initiatorPermCollection;
	}
	
	public MetaInitiatorPermCollection getInitiatorPermCollection() {
		return initiatorPermCollection;
	}

	public MetaAttachmentCollection getAttachmentCollection() {
		return attachmentCollection;
	}

	public void setAttachmentCollection(MetaAttachmentCollection attachmentCollection) {
		this.attachmentCollection = attachmentCollection;
	}
	
	public MetaParticipatorCollection getGlobeptorsCollection() {
		return globalptorCollection;
	}
	
	public void setGlobeptorsCollection(MetaParticipatorCollection globeptorsCollection) {
		this.globalptorCollection = globeptorsCollection;
	}
	
	public MetaEventCollection getEventCollection() {
		return eventCollection;
	}
	
	public void setEventCollection(MetaEventCollection eventCollection) {
		this.eventCollection = eventCollection;
	}

	public MetaRefFormCollection getRefFormCollection() {
		return refFormCollection;
	}

	public void setRefFormCollection(MetaRefFormCollection refFormCollection) {
		this.refFormCollection = refFormCollection;
	}
	
	public boolean isAllowRevokeAfterEnd() {
		return this.allowRevokeAfterEnd;
	}
	
	/**
	 * 通过结束节点的属性设置当前流程的部分动态属性
	 * 
	 * @param metaEnd
	 */
	private void prepareAttributeByEndNode(MetaEnd metaEnd) {
		this.allowRevokeAfterEnd = metaEnd.isWorkitemRevoke();
	}

	public String getWorkitemCreateTrigger() {
		return workitemCreateTrigger;
	}

	public void setWorkitemCreateTrigger(String workitemCreateTrigger) {
		this.workitemCreateTrigger = workitemCreateTrigger;
	}
	

	public MetaAdministratorCollection getAdministratorCollection() {
		return administratorCollection;
	}

	public void setAdministratorCollection(MetaAdministratorCollection administratorCollection) {
		this.administratorCollection = administratorCollection;
	}
	
	public MetaOperationCollection getAdministratorOperationCollection() {
		return administratorOperationCollection;
	}

	public void setAdministratorOperationCollection(MetaOperationCollection administratorOperationCollection) {
		this.administratorOperationCollection = administratorOperationCollection;
	}

	public String getForbidOperateMark() {
		return forbidOperateMark;
	}

	public void setForbidOperateMark(String forbidOperateMark) {
		this.forbidOperateMark = forbidOperateMark;
	}

	public void doPostProcess() throws MetaException {
		nodeMapByID = new TreeMap<Integer, MetaNode>();
		assistanceMapByID = new TreeMap<Integer, Integer>();
		assistanceMapByKey = new HashMap<String, String>();
		assistanceNodeMap = new TreeMap<Integer,MetaNode>();
		MetaBegin begin = null;
		
		preNodesMap = new HashMap<Integer,ArrayList<Integer>>();
		for (MetaNode n : elementMap.values()) {
			nodeMapByID.put(n.getID(), n);
			if (n instanceof MetaBegin) 
				begin = (MetaBegin) n;
			
			if (n instanceof MetaEnd) {
				this.prepareAttributeByEndNode((MetaEnd) n);
			}
			// 处理辅助节点
			if (n instanceof MetaUserTask) {
				MetaUserTask ut = (MetaUserTask) n;
				MetaAssistanceCollection ass = ut.getAssistanceCollection();
				if (ass != null && ass.size() > 0) {
					for (MetaNode node : ass) {
						assistanceMapByID.put(node.getID(), n.getID());
						assistanceMapByKey.put(node.getKey(), n.getKey());
					}
				}
			}
			
			buildAssistanceNodeMap(n);

			// 处理合并节点
			for (MetaTransition t : n.getTransitionCollection()) {
				String nodeKey = t.getTargetNodeKey();
				MetaNode node = elementMap.get(nodeKey);
				if (node.getNodeType() == NodeType.JOIN) {
					MetaJoin mj = (MetaJoin) node;
					mj.setJoinCount(mj.getJoinCount() + 1);
				}
				t.setTargetNode(node);
			}

			// 处理状态节点
			if (n.getNodeType() == NodeType.STATE) {
				boolean useStateTask = true;
				for (MetaTransition t : n.getTransitionCollection()) {
					if (t instanceof MetaSequenceFlow) {
						MetaNode node = t.getTargetNode();
						if (node.getNodeType() != NodeType.STATE_ACTION) {
							useStateTask = false;
							break;
						} else {
							((MetaStateAction) node).setStateNode((MetaState) n);
						}
					}

				}
				((MetaState) n).setUseStateTask(useStateTask);
			}

			// 处理状态动作节点
			if (n.getNodeType() == NodeType.STATE_ACTION) {
				MetaStateAction node = (MetaStateAction) n;
				node.getOperation().setCustomKey(n.getKey());
			}
			
			
			//处理每个节点及辅助节点的直接前驱节点
			calPreNodes(n);
			if (n instanceof MetaUserTask) {
				MetaUserTask ut = (MetaUserTask) n;
				MetaAssistanceCollection ass = ut.getAssistanceCollection();
				if (ass != null && ass.size() > 0) {
					for (MetaNode node : ass) {
						calPreNodes(node);
					}
				}
			}
		}
		
		//广度优先遍历计算节点深度
		traversal(begin);
		//从配置中检查配对的分支节点与合并节点
		checkForkJoin();
		//分支合并节点配对
		mateForkJoin();
	}
	
	private void buildAssistanceNodeMap(MetaNode n) {
		if (n instanceof MetaUserTask) {
			MetaUserTask ut = (MetaUserTask) n;
			MetaAssistanceCollection ass = ut.getAssistanceCollection();
			if (ass != null && ass.size() > 0) {
				for (MetaNode node : ass) {
					assistanceNodeMap.put(node.getID(), node);
					//递归遍历
					buildAssistanceNodeMap(node);
				}
			}
		}
	}

	/**
	 * 广度优先遍历计算节点深度
	 */
	private void traversal(MetaBegin begin) {
		
		begin.setDeep(0);
		begin.setMarked();
		Queue<Map<Integer, MetaNode>> queue = new LinkedList<Map<Integer,MetaNode>>();
		Map<Integer, MetaNode> map = new HashMap<Integer, MetaNode>();
		map.put(begin.getID(), begin);
		queue.offer(map);
		
		while(queue.size() > 0){
			map = queue.poll();
			for(MetaNode node : map.values()){
				Map<Integer, MetaNode> loop = new HashMap<Integer, MetaNode>();
				for(MetaTransition t : node.getTransitionCollection()){
					MetaNode tNode = t.getTargetNode();
					if (tNode.isMarked()) 
						continue;
					
					if (node.getNodeType()==NodeType.FORK || node.getNodeType()==NodeType.EXCLUSIVE_FORK) {
						tNode.setDeep(node.getDeep()+1);
					} else if (node.getNodeType() == NodeType.JOIN || node.getNodeType() == NodeType.COMPLEX_JOIN) {
						tNode.setDeep(node.getDeep()-1 < 0 ? 0 : node.getDeep()-1);
					} else {
						tNode.setDeep(node.getDeep());
					}
					tNode.setMarked();
					loop.put(tNode.getID(), tNode);
				}
				
				queue.add(loop);
			}
			
		}
	}
	/**
	 * 从配置中检查配对的合并节点与分支节点
	 */
	private void checkForkJoin() {
		for (MetaNode node : elementMap.values()) {
			if (node.getNodeType() == NodeType.JOIN || node.getNodeType() == NodeType.COMPLEX_JOIN) {
				MetaJoin join = (MetaJoin)node;
				int mateForkID = join.getMateForkID();
				if (mateForkID > 0) {
					MetaNode n = getNodeByID(mateForkID);
					if (n!= null && n.getNodeType() == NodeType.FORK) {
						join.setFork((MetaFork)n);
					}
				}
			}
		}
	}
	
	/**
	 * 分支合并节点配对
	 */
	private void mateForkJoin(){
		for (MetaNode n : elementMap.values()){
			if (n.getNodeType() == NodeType.FORK) {
				//记录已经寻找过的节点集合
				TreeSet<Integer> set = new TreeSet<>();
				boolean flag = false;
				int deep = 0;
				
				MetaTransitionCollection collection = n.getTransitionCollection();
				if (collection.size() == 0) 
					continue;
				MetaNode tNode = n.getTransitionCollection().get(0).getTargetNode();
				set.add(tNode.getID());
				if (tNode.getNodeType() == NodeType.FORK) {
					deep++;
				}
				while((tNode.getNodeType() != NodeType.JOIN && tNode.getNodeType() != NodeType.COMPLEX_JOIN) || deep > 0){
					if (tNode.getNodeType() == NodeType.FORK) {
						deep++;
					}
					if ((tNode.getNodeType() == NodeType.JOIN || tNode.getNodeType() == NodeType.COMPLEX_JOIN) && deep > 0) {
						deep--;
					}
					//寻找到无路径节点，跳出循环
					collection = tNode.getTransitionCollection();
					if (collection.size() == 0) {
						flag = true;
						break;
					}
					tNode = tNode.getTransitionCollection().get(0).getTargetNode();
					//如果当前节点已经寻找过，跳出当前循环，防止死循环
					if (set.contains(tNode.getID())) {
						flag = true;
						break;
					} else {
						set.add(tNode.getID());
					}
				}
				
				//当前配对失败，继续计算其他分支节点
				if (flag)
					continue;
				
				if (((MetaJoin)tNode).getFork() == null ){
					((MetaJoin)tNode).setFork((MetaFork)n);
				}
			}
		}
	}
	
	public void release(){
		for(MetaNode node : elementMap.values()){
			if (node.isMarked()) {
				node.setUnMarked();
			}
		}
	}
	
	private void calPreNodes(MetaNode node) {
		for (MetaTransition t : node.getTransitionCollection()) {
			String nodeKey = t.getTargetNodeKey();
			MetaNode n = elementMap.get(nodeKey);
			ArrayList<Integer>preNodes = preNodesMap.get(n.getID());
			if (preNodes == null) {
				preNodes = new ArrayList<>();
				preNodesMap.put(n.getID(), preNodes);
			}
			preNodes.add(node.getID());
		}
	}
	/**
	 * 获取指定节点的直接前驱节点的集合
	 * @param nodeId 节点的ID
	 * @return 前驱节点的ID的集合
	 */
	public ArrayList<Integer> getPreNodesById(Integer nodeId){
		ArrayList<Integer>preNodes = preNodesMap.get(nodeId);
		if (preNodes != null && !preNodes.isEmpty()) {
			return preNodes;
		}
		return null;
	}

	public HashMap<String, String> getAssistanceMapByKey() {
		return assistanceMapByKey;
	}

	public TreeMap<Integer, Integer> getAssistanceMapByID() {
		return assistanceMapByID;
	}

	@Override
	public JSONObject toJSON() {
		JSONObject obj = new JSONObject();
		obj.put("key", key);
		obj.put("caption", caption);
		obj.put("idSeed", idSeed);
		obj.put("version", version);
		JSONArray nodeArray = new JSONArray();
		Iterator<Entry<String, MetaNode>> itNode = this.elementMap.entrySet().iterator();
		Entry<String, MetaNode> entryNode = null;
		MetaNode node = null;
		while (itNode.hasNext()) {
			entryNode = itNode.next();
			node = entryNode.getValue();
			JSONObject objNode = node.toJSON();
			nodeArray.put(objNode);
		}
		obj.put("nodes", nodeArray);

		if (swimlineCollection != null) {
			JSONObject objSwinlines = swimlineCollection.toJSON();
			obj.put("swinlines", objSwinlines);
		}

		if (BPMInfoCollection != null) {
			JSONObject objBPMInfos = BPMInfoCollection.toJSON();
			obj.put("bpminfos", objBPMInfos);
		}

		if (dataMigrationTable != null) {
			JSONObject objDataMigrations = this.dataMigrationTable.toJSON();
			obj.put("datamigrations", objDataMigrations);
		}

		return obj;
	}

	@Override
	public void fromJSON(JSONObject json) {
		this.key = (String) json.optString("key");
		this.caption = (String) json.optString("caption");
		this.idSeed = json.optInt("idSeed");
		this.version = json.optInt("version");
		JSONArray nodeArray = json.optJSONArray("nodes");
		if (nodeArray != null) {
			for (int i = 0, length = nodeArray.length(); i < length; ++i) {
				JSONObject objNode = (JSONObject) nodeArray.get(i);
				String tagName = (String) objNode.getString("tag-name");
				MetaNode node = createNode(tagName);
				node.fromJSON(objNode);
				this.add(node);
			}
		}
		if (json.has("swinlines")) {
			swimlineCollection = new MetaSwimlineCollection();
			swimlineCollection.fromJSON(json.getJSONObject("swinlines"));
		}
		if (json.has("bpminfos")) {
			BPMInfoCollection = new MetaBPMInfoCollection();
			BPMInfoCollection.fromJSON(json.getJSONObject("bpminfos"));
		}
		if (json.has("datamigrations")) {
			dataMigrationTable = new MetaDMTable();
			dataMigrationTable.fromJSON(json.getJSONObject("datamigrations"));
		}
	}

	@Override
	public AbstractMetaObject clone() {
		MetaProcess newProcess = (MetaProcess) super.clone();
		newProcess.setKey(key);
		newProcess.setCaption(caption);
		newProcess.setIdSeed(idSeed);
		newProcess.setVersion(version);
		newProcess.setFormKey(formKey);
		newProcess.setQueryRetreatWorkitem(queryRetreatWorkitem);
		newProcess.setSwimlineCollection(swimlineCollection == null ? null : (MetaSwimlineCollection) swimlineCollection.clone());
		newProcess.setBPMInfoCollection(BPMInfoCollection == null ? null : (MetaBPMInfoCollection) BPMInfoCollection.clone());
		newProcess.setDataMigrationTable(dataMigrationTable == null ? null : (MetaDMTable) dataMigrationTable.clone());
		newProcess.setPermCollection(permCollection == null ? null : (MetaPermCollection) permCollection.clone());
		newProcess.setAttachmentCollection(attachmentCollection == null ? null : (MetaAttachmentCollection) attachmentCollection.clone());
		newProcess.setGlobeptorsCollection(globalptorCollection == null ? null : (MetaParticipatorCollection) globalptorCollection.clone());
		newProcess.eventCollection = eventCollection == null ? null : (MetaEventCollection)eventCollection.clone();
		newProcess.refFormCollection = refFormCollection == null ? null : (MetaRefFormCollection)refFormCollection.clone();
		newProcess.setTemplateKey(templateKey);
		newProcess.setIgnoreFormState(ignoreFormState);
		newProcess.setKillInstanceTrigger(killInstanceTrigger);
		newProcess.setExpand(expand == null ? null : (MetaExpand)expand.clone());
		newProcess.setInitiatorPermCollection(initiatorPermCollection == null ? null : (MetaInitiatorPermCollection)initiatorPermCollection.clone());
		newProcess.setAdministratorCollection(null == administratorCollection ? null : (MetaAdministratorCollection)administratorCollection.clone());
		newProcess.setAdministratorOperationCollection(null == administratorOperationCollection ? null : (MetaOperationCollection)administratorOperationCollection.clone());
		return newProcess;
	}

}
