package com.bokesoft.yigo.meta.bpm.process;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.bpm.MetaBPMLoad;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.total.MetaBPM;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessDeployInfo;
import com.bokesoft.yigo.meta.bpm.total.MetaProcessMap;
import com.bokesoft.yigo.meta.factory.workflow.ProcessSourceType;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaBPMReferenceScanLoad extends BaseMetaScanLoad {

	private MetaBPM metaBPM;

	/** 流程的目录结构，通过扫描得到 */
	private ProcessDefinitionFolder root;

	private Map<String, ProcessDefinitionProfile> profileMap = new ConcurrentHashMap<String, ProcessDefinitionProfile>();

	private Map<String, ProcessDefinitionFolder> folderMap = new ConcurrentHashMap<String, ProcessDefinitionFolder>();
	
	private int runType = AppRunType.App;

	public MetaBPMReferenceScanLoad(MetaBPM metaBPM, IMetaResolver resolver, MetaProject metaProject, Object context, int runType) throws Throwable {
		super(resolver, metaProject, metaProject.getKey() + File.separatorChar + DomMetaConstants.BPM_FOLD, context);
		this.metaBPM = metaBPM;
		this.runType = runType;
		root = loadProcessFolder("", resourcePath);
	}

	protected void loadImpl() throws Throwable {
		// 载入工作流工程配置
		MetaBPMLoad BPMLoad = new MetaBPMLoad(runType);
		String resource = resourcePath + ".xml";
		BPMLoad.load(resolver, resource);
		MetaBPM mb = (MetaBPM) BPMLoad.getRootMetaObject();
		if (mb != null) {
			for (MetaProcessDeployInfo info : mb.getMetaBPMDeployInfoCollection()) {
				metaBPM.getMetaBPMDeployInfoCollection().add(info);
			}
			for (MetaProcessMap info : mb.getMetaProcessMapCollection()) {
				metaBPM.getMetaProcessMapCollection().add(info);
			}
		}
		scan(null, resourcePath);
	}

	protected void postLoad() throws Throwable {
		super.postLoad();
		metaBPM.getProfileMap().putAll(getProfileMap());
	}
	
	@Override
	protected Object loadFolder(Object parent, String path, String filePath) throws Throwable {
		ProcessDefinitionFolder folder = new ProcessDefinitionFolder();
		folder.setPath(filePath);
		folder.setCaption(path);
		folder.setKey(path);
		folderMap.put(filePath, folder);
		return null;
	}

	private ProcessDefinitionFolder loadProcessFolder(String filePath, String fileName) throws Throwable {
		String resource = filePath + File.separatorChar + fileName;
		if (filePath.length() == 0)
			resource = fileName;

		ProcessDefinitionFolder folder = new ProcessDefinitionFolder();
		folder.setPath(resource);
		folder.setCaption(fileName);
		folder.setKey(fileName);
		folderMap.put(folder.getPath(), folder);

		if (filePath.length() == 0) {
			folder.setCaption("业务流程");
			return folder;
		}
		InputStream ins = resolver.read(resource + File.separatorChar + FolderInfo.FILE_NAME, 0);
		if (ins != null) {
			Document document = DomHelper.createDocument(ins);
			Element rootElement = document.getDocumentElement();
			String caption = DomHelper.readAttr(rootElement, BPMConstants.COMMON_CAPTION, "");
			folder.setCaption(caption);
			ins.close();
		}
		return folder;
	}

	public ProcessDefinitionFolder getRoot() {
		return root;
	}

	public Map<String, ProcessDefinitionProfile> getProfileMap() {
		return profileMap;
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaProcess.TAG_NAME.equals(tagName)) {
				ProcessDefinitionProfile processProfile = new ProcessDefinitionProfile();
				String key = profileInfo.optString(BPMConstants.COMMON_KEY);
				String caption = profileInfo.optString(BPMConstants.COMMON_CAPTION);
				String versionStr = profileInfo.optString(BPMConstants.COMMON_VERSION);
				Integer version = (versionStr == null || versionStr.length() == 0) ? 1 : Integer.parseInt(versionStr);
				processProfile.setKey(key);
				processProfile.setCaption(caption);
				processProfile.setVersion(version);
				processProfile.setResource(filePath);
				processProfile.setProject(metaProject);
				processProfile.setSourceType(ProcessSourceType.DIRECTORY);
				profileMap.put(key + "_V" + version, processProfile);
				folderMap.get(parentPath).getProfileList().add(processProfile);
			}
		}
	}
}
