package com.bokesoft.yigo.meta.base;

import java.util.LinkedList;

import com.bokesoft.yigo.meta.intf.IMetaProject;
import com.bokesoft.yigo.meta.report.MetaReport;

/**
 * 普通文件预加载信息，key为文件名称
 * 
 * @author chenbb
 *
 */
public class MetaGenericProfile extends KeyPairMetaObject {
	/** 报表的标识 */
	private String key = "";
	/** 最终加载结果  */
	private Object content = null;
	/** 工程引用 */
	private IMetaProject project = null;
	/** 资源 */
	private String resource = null;

	@Override
	public String getKey() {
		return this.key;
	}

	/**
	 * 设置报表的标识
	 * 
	 * @param key
	 *            标识
	 */
	public void setKey(String key) {
		this.key = key;
	}

	/**
	 * 取得名称
	 * 
	 * @return 名称
	 */
	public String getCaption() {
		return this.key;
	}

	/**
	 * 设置实际加载内容
	 * 
	 * @param workbook
	 *            报表配置
	 * @see MetaReport
	 */
	public void setContent(Object content) {
		this.content = content;
	}

	/**
	 * 取得实际加载内容
	 * 
	 * @return 报表配置
	 * @see MetaReport
	 */
	public Object getContent() {
		return this.content;
	}

	/**
	 * 设置工程引用
	 * 
	 * @param project
	 *            工程引用
	 */
	public void setProject(IMetaProject project) {
		this.project = project;
	}

	/**
	 * 取得工程引用
	 * 
	 * @return 工程引用
	 */
	public IMetaProject getProject() {
		return this.project;
	}

	/**
	 * 设置资源
	 * 
	 * @param resource
	 *            资源
	 */
	public void setResource(String resource) {
		this.resource = resource;
	}

	/**
	 * 取得资源
	 * 
	 * @return 资源
	 */
	public String getResource() {
		return this.resource;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getTagName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc,
			Object node, String tagName, Object flag, int runType)
			throws MetaException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public AbstractMetaObject newInstance() {
		// TODO Auto-generated method stub
		return null;
	}

}
