package com.bokesoft.yigo.meta.archive;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

/**
 * 数据归档的元数据
 * 
 * 
 * @author wubh
 *
 */
public class MetaArchive extends AbstractMetaObject{
	
	public static final String TAG_NAME = "Archive";
	
	/** 归档规则集合*/
	private MetaArchiveRuleCollection archiveRuleCollection = null;
	
	public MetaArchiveRuleCollection getArchiveRuleCollection() {
		return archiveRuleCollection;
	}

	public void setArchiveRuleCollection(MetaArchiveRuleCollection archiveRuleCollection) {
		this.archiveRuleCollection = archiveRuleCollection;
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		addAll(list, new AbstractMetaObject[] {archiveRuleCollection});
	}

	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {	
		
		AbstractMetaObject resultMetaObject = null;
		if (tagName.equalsIgnoreCase(MetaArchiveRuleCollection.TAG_NAME)) {
			resultMetaObject = new MetaArchiveRuleCollection();
			archiveRuleCollection = (MetaArchiveRuleCollection)resultMetaObject;
		} 
		return resultMetaObject;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaArchive newObj = new MetaArchive();
		newObj.archiveRuleCollection = archiveRuleCollection == null ? null : (MetaArchiveRuleCollection)archiveRuleCollection.clone();
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaArchive();
	}
	
	@Override
	public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
		super.doPostProcess(flag, callback);
		if (archiveRuleCollection != null) {
			archiveRuleCollection.doPostProcess(flag, callback);
		}
	}
	
}
