package com.bokesoft.yes.meta.process.struct;

public class TokenIDUtil {
	/**
	 * 取得列标识
	 * @param columnIndex 列序号
	 * @return 以Excel中列标识的规则表示的字符串
	 */
	public static String toColumnID(int columnIndex) {
		char begin = 'A';
		char end = 'Z';
		int count = end - begin + 1;

		int multiple = 0;
		int remainder = 0;
		multiple = columnIndex / count;
		remainder = columnIndex % count;
		columnIndex = multiple;

		String colID = "";
		char ch;
		ch = (char) (begin + remainder);
		colID = ch + colID;
		// Do until multiple equals 0
		while (multiple != 0) {
			multiple = columnIndex / count;
			remainder = columnIndex % count;
			columnIndex = multiple;
			ch = (char) (begin + remainder - 1);
			colID = ch + colID;
		}

		return colID;
	}

	/**
	 * 从列标识中取得列序号
	 * @param columnID 以Excel中列标识规则表示的字符串
	 * @return 列序号
	 */
	public static int toColumnIndex(String columnID) {
		char begin = 'A';
		char end = 'Z';
		int count = end - begin + 1;
		int length = columnID.length();
		char c = ' ';
		int columnIndex = 0;
		for (int i = length - 1; i >= 0; --i) {
			c = columnID.charAt(length - i - 1);
			if (i == 0) {
				columnIndex += (c - begin);
			} else {
				columnIndex += (c - begin + 1) * sqr(count, i);
			}
		}
		return columnIndex;
	}

	private static int sqr(int a, int b) {
		if (b == 0) {
			return 1;
		}
		int r = a;
		for (int i = 0; i < b - 1; ++i) {
			r *= a;
		}
		return r;
	}
	
	public static int getSeparatorPos(String s) {
		int pos = -1;
		for ( int i = 0, length = s.length(); i<length; ++i ) {
			if ( Character.isDigit(s.charAt(i)) ) {
				pos = i - 1;
				break;
			}
		}
		return pos;
	}
}
