package com.bokesoft.yes.meta.persist.dom.xml.parse;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;

public class Util {
	public static int getBeginIndex(String xml) {
		return Ignorer.getXmlBeginIndex(xml);
	}

	public static String deleteXmlHead(String xml) {
		if (xml == null) {
			return null;
		}

		int c = getBeginIndex(xml);
		if (c > 0) {
			return xml.substring(c);
		}
		return xml;
	}

	public static List<Element> getElements(String xml) {
		if (xml == null) {
			return null;
		}

		xml = deleteXmlHead(xml);

		List<Element> list = new ArrayList<Element>();
		int ix = 0;
		int maxIndex = xml.length();

		while (ix < maxIndex) {
			Element ele = getNextElement(xml, ix);
			list.add(ele);
			ix = ele.endIndex + 1;
		}

		return list;
	}

	public static Element getNextElement(String xml, int bg) {
		for (int i = bg; i < xml.length(); i++) {
			char c = xml.charAt(i);

			if (c != '<')
				continue;
			if (i != bg) {
				Element ele = new Element();
				ele.bgIndex = bg;
				ele.type = 1;
				ele.text = xml.substring(bg, i);
				ele.endIndex = (i - 1);
				return ele;
			}

			if (StringUtil.isString(xml, "</", i)) {
				return PrivateUtil.getEndTag(xml, i);
			}
			if (StringUtil.isString(xml, "<!--", i))
				return PrivateUtil.getComment(xml, i);
			if (StringUtil.isString(xml, "<![CDATA[", i))
				return PrivateUtil.getCDATA(xml, i);
			if (StringUtil.isString(xml, "<!DOCTYPE", i)) {
				return PrivateUtil.getDTD(xml, i);
			}

			return PrivateUtil.getStartTag(xml, i);
		}

		Element ele = new Element();
		ele.bgIndex = bg;
		ele.type = 1;
		ele.endIndex = (xml.length() - 1);
		ele.text = xml.substring(bg);

		return ele;
	}

	public String deleteNotUse(String xml) {
		return xml;
	}
}