package com.bokesoft.yes.meta.persist.dom.xml.node;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.yes.common.util.StringUtil;

public abstract class AbstractNode {

	protected String text = null;
	
	private TagNode parent = null;
	
	public AbstractNode(String text) {
		this.text = text;
	}
	
	public String getText() {
		return text;
	}
	
	public void appendLevelBlank(StringBuilder strBuilder, int level) {
		for (int i = 0; i < level; i++) {
			strBuilder.append("    ");
		}
	}
	
	public abstract String toXml(int level);
	
	public abstract AbstractNode clone();
	
	public abstract boolean hasPrimaryAttribute();
	
	public TagNode getParent() {
		return this.parent;
	}

	public void setParent(TagNode parent) {
		this.parent = parent;
	}
	
	public boolean isRoot() {
		return this.parent == null;
	}
	
	private List<AbstractNode> preCommnetList = null;

	private List<AbstractNode> lastCommnetList = null;
	
	public void addPreComment(List<AbstractNode> comments) {
		if (comments == null) {
			return;
		}
		if (preCommnetList == null) {
			preCommnetList = new ArrayList<AbstractNode>();
		}
		for (AbstractNode node : comments) {
			preCommnetList.add(node);
		}
	}
	
	public void addLastComment(List<AbstractNode> comments) {
		if (comments == null) {
			return;
		}
		if (lastCommnetList == null) {
			lastCommnetList = new ArrayList<AbstractNode>();
		}
		for (AbstractNode node : comments) {
			lastCommnetList.add(node);
		}
	}
	
	public List<AbstractNode> getPreComment() {
		return preCommnetList;
	}

	public List<AbstractNode> getLastComment() {
		return lastCommnetList;
	}

	protected String convertSpecialChars(String str) {
		str = StringUtil.replaceAll(str, "&", "&amp;");
		str = StringUtil.replaceAll(str, "<", "&lt;");
		str = StringUtil.replaceAll(str, ">", "&gt;");
		//str = StringUtil.replaceAll(str, "'", "&apos;");
		str = StringUtil.replaceAll(str, "\"", "&quot;");
		return str;
	}
}
