package com.bokesoft.yes.meta.persist.dom.solution;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.solution.MetaLang;

import java.math.BigDecimal;

public class MetaLangAction extends BaseDomAction<MetaLang>{

    @Override
    public void load(Document document, Element element, MetaLang meta,	int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
        meta.setSuffix(DomHelper.readAttr(element, MetaConstants.LANG_SUFFIX, meta.getKey()));
        meta.setWidthMultiple(DomHelper.readAttr(element, MetaConstants.WIDTH_MULTIPLE, meta.getWidthMultiple()));
        meta.setBaseLang(DomHelper.readAttr(element, MetaConstants.LANG_BASE_LANG, MetaLang.BaseLang_ZH));
        meta.setEnableTranslate(DomHelper.readBool(element, MetaConstants.LANG_ENABLE_TRANSLATE, true));
    }

    @Override
    public void save(Document document, Element element, MetaLang meta,	int runType) {
        DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
        DomHelper.writeAttr(element, MetaConstants.LANG_SUFFIX, meta.getSuffix(), meta.getKey());
        String widthMultiple = (new BigDecimal(meta.getWidthMultiple())).compareTo(new BigDecimal("1")) == 0 ? "1" : meta.getWidthMultiple();
        DomHelper.writeAttr(element, MetaConstants.WIDTH_MULTIPLE, widthMultiple, "1");
        DomHelper.writeAttr(element, MetaConstants.LANG_BASE_LANG, meta.getBaseLang(), MetaLang.BaseLang_ZH);
        DomHelper.writeAttr(element, MetaConstants.LANG_ENABLE_TRANSLATE, meta.isEnableTranslate(), true);
    }
}
