package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yigo.meta.form.MetaExtFormList;
import org.json.JSONObject;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.meta.persist.dom.DomMetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.dynamic.MetaDynamicCellLoad;
import com.bokesoft.yigo.common.def.AppRunType;
import com.bokesoft.yigo.common.def.FormType;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.form.component.grid.dynamic.MetaCellTypeTable;
import com.bokesoft.yigo.meta.solution.MetaProject;

public class MetaFormScanLoad extends BaseMetaScanLoad {
	private MetaFormList formList = null;
	private MetaCellTypeTable cellTypeTable = null;
	//扩展表单列表
	private MetaExtFormList extFormList = null;
	public MetaFormScanLoad(MetaFormList formList,MetaCellTypeTable cellTypeTable,
			IMetaResolver resolver, MetaProject metaProject, Object context) {
		super(resolver, metaProject, DomMetaConstants.FORM_FOLD, context);
		this.formList = formList;

		this.cellTypeTable = cellTypeTable;
	}
	
	protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaFormProfile profile) {
		
	}

	@Override
	public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
		JSONObject profileInfo = resolver.readProfile(filePath, 0);
		if (profileInfo != null) {
			String tagName = profileInfo.optString(MetaConstants.COMMON_TAG_NAME);
			if (MetaForm.TAG_NAME.equals(tagName)) {
				MetaFormProfile formProfile = new MetaFormProfile();
				formProfile.setKey(profileInfo.optString(MetaConstants.COMMON_KEY));
				formProfile.setCaption(profileInfo.optString(MetaConstants.COMMON_CAPTION));
				formProfile.setResource(filePath);
				formProfile.setFormType(FormType.parse(profileInfo.optString(MetaConstants.FORM_FORMTYPE)));
				formProfile.setExtend(profileInfo.optString(MetaConstants.FORM_EXTEND));
				formProfile.setMergeToSource(profileInfo.optBoolean(MetaConstants.FORM_MERGETOSOURCE, false));
				formProfile.setProject(metaProject);
				formProfile.setPlatform(PlatformType.parse(profileInfo.optString(MetaConstants.COMMON_PLATFORM)));
				formProfile.setAliasKey(profileInfo.optString(MetaConstants.COMMON_ALIAS_KEY));
				formProfile.setSourceForm(profileInfo.optString(MetaConstants.FORM_SOURCEFORM));
				doFind(parent, parentPath, filePath, fileName, formProfile);

				if (formProfile.getFormType() == FormType.Extension) {
					if (extFormList != null) {
						if (extFormList.containsKey(formProfile.getKey())) {
							throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
									SimpleStringFormat.format(
											StringTable.getString(null, "", StringTable.RepeatFormDefined),
											metaProject.getKey(), formProfile.getKey()));
						}
						extFormList.add(formProfile);
					}
				}else {
					if (formList.containsKey(formProfile.getKey())) {
						throw new MetaException(MetaException.REPEAT_FORM_DEFINED,
								SimpleStringFormat.format(
										StringTable.getString(null, "", StringTable.RepeatFormDefined),
										metaProject.getKey(), formProfile.getKey()));
					}
					formList.add(formProfile);
				}
			}else if (MetaCellTypeTable.TAG_NAME.equals(tagName)) {
				MetaDynamicCellLoad load = new MetaDynamicCellLoad(AppRunType.App);
				try {
					load.load(resolver, filePath);
					MetaCellTypeTable table = (MetaCellTypeTable) load.getRootMetaObject();
					if (table != null && cellTypeTable != null) {
						cellTypeTable.merge(table);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	public MetaCellTypeTable getCellTypeTable() {
		return cellTypeTable;
	}

	public void setExtFormKeyList(MetaExtFormList extFormList) {
		this.extFormList = extFormList;
	}
}
