package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaFormSetting;

public class MetaFormSettingAction extends BaseDomAction<MetaFormSetting> {

	@Override
	public void load(Document document, Element element, MetaFormSetting meta,
			int runType) {
		meta.setInitFocus(DomHelper.readAttr(element, MetaConstants.INITFOCUS, true));
		meta.setRightsProvider(DomHelper.readAttr(element, MetaConstants.RIGHTS_PROVIDER, ""));
		meta.setDimValueProvider(DomHelper.readAttr(element, MetaConstants.DIMVALUE_PROVIDER, ""));
	}

	@Override
	public void save(Document document, Element element, MetaFormSetting meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.INITFOCUS, meta.initFocus(), true);
		DomHelper.writeAttr(element, MetaConstants.RIGHTS_PROVIDER, meta.getRightsProvider(), "");
		DomHelper.writeAttr(element, MetaConstants.DIMVALUE_PROVIDER, meta.getDimValueProvider(), "");
	}
}