/**
 * 
 */
package com.bokesoft.yes.meta.persist.dom.setting;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.setting.MetaDTSProvider;

/**
 * @author lingc
 *
 */
public class MetaDTSProviderAction extends BaseDomAction<MetaDTSProvider> {

	@Override
	public void load(Document document, Element element,
			MetaDTSProvider meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setDriver(DomHelper.readAttr(element, MetaConstants.DTSPROVIDER_DRIVER, ""));
		meta.setExternalConfig(DomHelper.readAttr(element, MetaConstants.DTSSERVICE_EXTERNALCONFIG, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaDTSProvider meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DTSPROVIDER_DRIVER, meta.getDriver(), "");
		DomHelper.writeAttr(element, MetaConstants.DTSSERVICE_EXTERNALCONFIG, meta.getExternalConfig(), "");
	}
}
