package com.bokesoft.yes.meta.persist.dom.report.embed;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.MetaReportConstants;
import com.bokesoft.yigo.meta.report.embed.MetaReportImage;
public class MetaReportImageAction extends MetaReportEmbedObjectAction<MetaReportImage> {

	@Override
	public void load(Document document, Element element, MetaReportImage meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setPath(DomHelper.readAttr(element, MetaConstants.COMMON_PATH, ""));
		meta.setImageScaleType(ImageScaleType.parse(DomHelper.readAttr(element, MetaReportConstants.CELL_IMAGE_SCALE_TYPE, ImageScaleType.STR_FIT_XY)));
	}

	@Override
	public void save(Document document, Element element, MetaReportImage meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaReportConstants.CELL_IMAGE_SCALE_TYPE, ImageScaleType.toString(meta.getImageScaleType()), ImageScaleType.STR_FIT_XY);
	}

}
