package com.bokesoft.yes.meta.persist.dom.report.embed;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ChartType;
import com.bokesoft.yigo.common.def.EChartRenderType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.report.embed.MetaReportChart;

public class MetaReportChartAction extends MetaReportEmbedObjectAction<MetaReportChart> {

	@Override
	public void load(Document document, Element element, MetaReportChart meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setChartType(ChartType.parse(DomHelper.readAttr(element, MetaConstants.CHART_CHART_TYPE, ChartType.STR_Line)));
		meta.setTitle(DomHelper.readAttr(element, MetaConstants.CHART_TITLE, ""));
		meta.setSeriesInRow(DomHelper.readAttr(element, MetaConstants.CHART_SERIES_IN_ROW, false));
		meta.setSeriesAxisTitle(DomHelper.readAttr(element, MetaConstants.CHART_SERIES_AXIS_TITLE, ""));
		meta.setCategoryAxisTitle(DomHelper.readAttr(element, MetaConstants.CHART_CATEGORY_AXIS_TITLE, ""));
		meta.setShowValue(DomHelper.readAttr(element, MetaConstants.CHART_SHOW_VALUES, true));
		meta.setFill(DomHelper.readAttr(element, MetaConstants.CHART_FILL, false));
		meta.setRenderType(EChartRenderType.valueOf(DomHelper.readAttr(element, MetaConstants.REPORT_CHART_RENDERTYPE, EChartRenderType.Draw.toString())));
	}

	@Override
	public void save(Document document, Element element, MetaReportChart meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_CHART_TYPE, ChartType.toString(meta.getChartType()), ChartType.STR_Line);
		DomHelper.writeAttr(element, MetaConstants.CHART_TITLE, meta.getTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_SERIES_IN_ROW, meta.getSeriesInRow(), false);
		DomHelper.writeAttr(element, MetaConstants.CHART_SERIES_AXIS_TITLE, meta.getSeriesAxisTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_CATEGORY_AXIS_TITLE, meta.getCategoryAxisTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.CHART_SHOW_VALUES, meta.isShowValue(), true);
		DomHelper.writeAttr(element, MetaConstants.CHART_FILL, meta.isFill(), false);
		DomHelper.writeAttr(element, MetaConstants.REPORT_CHART_RENDERTYPE, meta.getRenderType().toString(), EChartRenderType.Draw.toString());
	}

}
