package com.bokesoft.yes.meta.persist.dom.mobiledef;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mobiledef.MetaExtClass;

public class MetaExtClassAction extends BaseDomAction<MetaExtClass>{

	@Override
	public void load(Document document, Element element, MetaExtClass meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setPlatform(PlatformType.parse(DomHelper.readAttr(element, MetaConstants.COMMON_PLATFORM, "")));
		meta.setPath(DomHelper.readAttr(element, MetaConstants.COMMON_PATH, ""));
		meta.setInitClass(DomHelper.readAttr(element, MetaConstants.CXTCLASS_INITCLASS, ""));
	}

	@Override
	public void save(Document document, Element element, MetaExtClass meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_PLATFORM,PlatformType.toString(meta.getPlatform()), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_PATH, meta.getPath(), "");
		DomHelper.writeAttr(element, MetaConstants.CXTCLASS_INITCLASS, meta.getInitClass(), "");
	}

}
