package com.bokesoft.yes.meta.persist.dom.mapping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.mapping.MetaRelationItem;

public class MetaRelationItemAction extends MetaMapElementAction<MetaRelationItem> {

	@Override
	public void load(Document document, Element element, MetaRelationItem meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTableKey(DomHelper.readAttr(element, MetaMappingConstants.TABLEKEY, ""));
		meta.setColumnKey(DomHelper.readAttr(element, MetaMappingConstants.COLUMNKEY, ""));
		meta.setNextColumn(DomHelper.readAttr(element, MetaMappingConstants.NEXT_COLUMN, ""));
		meta.setTgtNodeID(DomHelper.readAttr(element, MetaMappingConstants.TGTNODEID, -1));
		meta.setExpandSQL(DomHelper.readAttr(element, MetaMappingConstants.EXPAND_SQL, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRelationItem meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaMappingConstants.TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.NEXT_COLUMN, meta.getNextColumn(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.EXPAND_SQL, meta.getExpandSQL(), "");
		DomHelper.writeAttr(element, MetaMappingConstants.TGTNODEID, meta.getTgtNodeID(), -1);
	}

}
